/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.MatchConditions;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.data.appconfiguration.ConfigurationClient;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.ConfigurationSnapshot;
import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.data.appconfiguration.models.SnapshotComposition;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationStatusException;
import com.azure.spring.cloud.appconfiguration.config.implementation.NormalizeNull;
import com.azure.spring.cloud.appconfiguration.config.implementation.feature.FeatureFlags;
import com.azure.spring.cloud.appconfiguration.config.implementation.http.policy.TracingInfo;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;

class AppConfigurationReplicaClient {
    private final String endpoint;
    private final ConfigurationClient client;
    private Instant backoffEndTime;
    private int failedAttempts;
    private final TracingInfo tracingInfo;

    AppConfigurationReplicaClient(String endpoint, ConfigurationClient client, TracingInfo tracingInfo) {
        this.endpoint = endpoint;
        this.client = client;
        this.backoffEndTime = Instant.now().minusMillis(1L);
        this.failedAttempts = 0;
        this.tracingInfo = tracingInfo;
    }

    Instant getBackoffEndTime() {
        return this.backoffEndTime;
    }

    void updateBackoffEndTime(Instant backoffEndTime) {
        this.backoffEndTime = backoffEndTime;
        ++this.failedAttempts;
    }

    int getFailedAttempts() {
        return this.failedAttempts;
    }

    String getEndpoint() {
        return this.endpoint;
    }

    ConfigurationSetting getWatchKey(String key, String label) throws HttpResponseException {
        try {
            ConfigurationSetting watchKey = NormalizeNull.normalizeNullLabel(this.client.getConfigurationSetting(key, label));
            this.failedAttempts = 0;
            return watchKey;
        }
        catch (HttpResponseException e) {
            throw this.hanndleHttpResponseException(e);
        }
        catch (UncheckedIOException e) {
            throw new AppConfigurationStatusException(e.getMessage(), null, null);
        }
    }

    List<ConfigurationSetting> listSettings(SettingSelector settingSelector) throws HttpResponseException {
        ArrayList<ConfigurationSetting> configurationSettings = new ArrayList<ConfigurationSetting>();
        try {
            PagedIterable settings = this.client.listConfigurationSettings(settingSelector);
            settings.forEach(setting -> configurationSettings.add(NormalizeNull.normalizeNullLabel(setting)));
            this.failedAttempts = 0;
            return configurationSettings;
        }
        catch (HttpResponseException e) {
            throw this.hanndleHttpResponseException(e);
        }
        catch (UncheckedIOException e) {
            throw new AppConfigurationStatusException(e.getMessage(), null, null);
        }
    }

    FeatureFlags listFeatureFlags(SettingSelector settingSelector) throws HttpResponseException {
        ArrayList<ConfigurationSetting> configurationSettings = new ArrayList<ConfigurationSetting>();
        ArrayList checks = new ArrayList();
        try {
            this.client.listConfigurationSettings(settingSelector).streamByPage().forEach(pagedResponse -> {
                checks.add(new MatchConditions().setIfNoneMatch(pagedResponse.getHeaders().getValue(HttpHeaderName.ETAG)));
                for (ConfigurationSetting featureFlag : pagedResponse.getValue()) {
                    configurationSettings.add((ConfigurationSetting)((FeatureFlagConfigurationSetting)NormalizeNull.normalizeNullLabel(featureFlag)));
                }
            });
            this.failedAttempts = 0;
            settingSelector.setMatchConditions(checks);
            return new FeatureFlags(settingSelector, configurationSettings);
        }
        catch (HttpResponseException e) {
            throw this.hanndleHttpResponseException(e);
        }
        catch (UncheckedIOException e) {
            throw new AppConfigurationStatusException(e.getMessage(), null, null);
        }
    }

    List<ConfigurationSetting> listSettingSnapshot(String snapshotName) {
        ArrayList<ConfigurationSetting> configurationSettings = new ArrayList<ConfigurationSetting>();
        try {
            ConfigurationSnapshot snapshot = this.client.getSnapshot(snapshotName);
            if (!SnapshotComposition.KEY.equals((Object)snapshot.getSnapshotComposition())) {
                throw new IllegalArgumentException("Snapshot " + snapshotName + " needs to be of type Key.");
            }
            PagedIterable settings = this.client.listConfigurationSettingsForSnapshot(snapshotName);
            this.failedAttempts = 0;
            settings.forEach(setting -> configurationSettings.add(NormalizeNull.normalizeNullLabel(setting)));
            return configurationSettings;
        }
        catch (HttpResponseException e) {
            throw this.hanndleHttpResponseException(e);
        }
        catch (UncheckedIOException e) {
            throw new AppConfigurationStatusException(e.getMessage(), null, null);
        }
    }

    Boolean checkWatchKeys(SettingSelector settingSelector) {
        List<PagedResponse> results = this.client.listConfigurationSettings(settingSelector).streamByPage().filter(pagedResponse -> pagedResponse.getStatusCode() != 304).toList();
        return results.size() > 0;
    }

    void updateSyncToken(String syncToken) {
        if (StringUtils.hasText((String)syncToken)) {
            this.client.updateSyncToken(syncToken);
        }
    }

    private HttpResponseException hanndleHttpResponseException(HttpResponseException e) {
        int statusCode;
        if (e.getResponse() != null && ((statusCode = e.getResponse().getStatusCode()) == HttpResponseStatus.TOO_MANY_REQUESTS.code() || statusCode == HttpResponseStatus.REQUEST_TIMEOUT.code() || statusCode >= HttpResponseStatus.INTERNAL_SERVER_ERROR.code())) {
            return new AppConfigurationStatusException(e.getMessage(), e.getResponse(), e.getValue());
        }
        return e;
    }

    TracingInfo getTracingInfo() {
        return this.tracingInfo;
    }
}

