/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.policy.ExponentialBackoff;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.Configuration;
import com.azure.data.appconfiguration.ConfigurationClientBuilder;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.spring.cloud.appconfiguration.config.ConfigurationClientCustomizer;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.http.policy.BaseAppConfigurationPolicy;
import com.azure.spring.cloud.appconfiguration.config.implementation.http.policy.TracingInfo;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.ConfigStore;
import com.azure.spring.cloud.core.provider.connectionstring.ServiceConnectionStringProvider;
import com.azure.spring.cloud.core.service.AzureServiceType;
import com.azure.spring.cloud.service.implementation.appconfiguration.ConfigurationClientBuilderFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.convert.DurationStyle;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AppConfigurationReplicaClientsBuilder
implements EnvironmentAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationReplicaClientsBuilder.class);
    public static final String NON_EMPTY_MSG = "%s property should not be null or empty in the connection string of Azure Config Service.";
    public static final String RETRY_MODE_PROPERTY_NAME = "retry.mode";
    public static final String MAX_RETRIES_PROPERTY_NAME = "retry.exponential.max-retries";
    public static final String BASE_DELAY_PROPERTY_NAME = "retry.exponential.base-delay";
    public static final String MAX_DELAY_PROPERTY_NAME = "retry.exponential.max-delay";
    private static final Duration DEFAULT_MIN_RETRY_POLICY = Duration.ofMillis(800L);
    private static final Duration DEFAULT_MAX_RETRY_POLICY = Duration.ofSeconds(8L);
    private static final String CONN_STRING_REGEXP = "Endpoint=([^;]+);Id=([^;]+);Secret=([^;]+)";
    public static final String ENDPOINT_ERR_MSG = String.format("Connection string does not follow format %s.", "Endpoint=([^;]+);Id=([^;]+);Secret=([^;]+)");
    private static final Pattern CONN_STRING_PATTERN = Pattern.compile("Endpoint=([^;]+);Id=([^;]+);Secret=([^;]+)");
    private ConfigurationClientCustomizer clientProvider;
    private final ConfigurationClientBuilderFactory clientFactory;
    private Environment env;
    private boolean isDev = false;
    private boolean isKeyVaultConfigured = false;
    private final boolean credentialConfigured;
    private final int defaultMaxRetries;

    public AppConfigurationReplicaClientsBuilder(int defaultMaxRetries, ConfigurationClientBuilderFactory clientFactory, boolean credentialConfigured) {
        this.defaultMaxRetries = defaultMaxRetries;
        this.clientFactory = clientFactory;
        this.credentialConfigured = credentialConfigured;
    }

    public static String getEndpointFromConnectionString(String connectionString) {
        Assert.hasText((String)connectionString, (String)"Connection string cannot be empty.");
        Matcher matcher = CONN_STRING_PATTERN.matcher(connectionString);
        if (!matcher.find()) {
            throw new IllegalStateException(ENDPOINT_ERR_MSG);
        }
        String endpoint = matcher.group(1);
        Assert.hasText((String)endpoint, (String)String.format(NON_EMPTY_MSG, "Endpoint"));
        return endpoint;
    }

    public void setClientProvider(ConfigurationClientCustomizer clientProvider) {
        this.clientProvider = clientProvider;
    }

    public void setIsKeyVaultConfigured(boolean isKeyVaultConfigured) {
        this.isKeyVaultConfigured = isKeyVaultConfigured;
    }

    List<AppConfigurationReplicaClient> buildClients(ConfigStore configStore) {
        boolean connectionStringIsPresent;
        int hasMultiConnectionString;
        ArrayList<AppConfigurationReplicaClient> clients = new ArrayList<AppConfigurationReplicaClient>();
        int hasSingleConnectionString = StringUtils.hasText((String)configStore.getConnectionString()) ? 1 : 0;
        int hasMultiEndpoints = configStore.getEndpoints().size() > 0 ? 1 : 0;
        int n = hasMultiConnectionString = configStore.getConnectionStrings().size() > 0 ? 1 : 0;
        if (hasSingleConnectionString + hasMultiEndpoints + hasMultiConnectionString > 1) {
            throw new IllegalArgumentException("More than 1 Connection method was set for connecting to App Configuration.");
        }
        boolean bl = connectionStringIsPresent = configStore.getConnectionString() != null || configStore.getConnectionStrings().size() > 0;
        if (this.credentialConfigured && connectionStringIsPresent) {
            throw new IllegalArgumentException("More than 1 Connection method was set for connecting to App Configuration.");
        }
        List<String> connectionStrings = configStore.getConnectionStrings();
        List<String> endpoints = configStore.getEndpoints();
        if (connectionStrings.size() == 0 && StringUtils.hasText((String)configStore.getConnectionString())) {
            connectionStrings.add(configStore.getConnectionString());
        }
        if (endpoints.size() == 0 && StringUtils.hasText((String)configStore.getEndpoint())) {
            endpoints.add(configStore.getEndpoint());
        }
        if (connectionStrings.size() > 0) {
            for (String connectionString : connectionStrings) {
                this.clientFactory.setConnectionStringProvider((ServiceConnectionStringProvider)new ConnectionStringConnector(connectionString));
                String endpoint = AppConfigurationReplicaClientsBuilder.getEndpointFromConnectionString(connectionString);
                LOGGER.debug("Connecting to " + endpoint + " using Connecting String.");
                ConfigurationClientBuilder builder = this.createBuilderInstance().connectionString(connectionString);
                clients.add(this.modifyAndBuildClient(builder, endpoint, connectionStrings.size() - 1));
            }
        } else {
            for (String endpoint : endpoints) {
                ConfigurationClientBuilder builder = this.createBuilderInstance();
                if (!this.credentialConfigured) {
                    LOGGER.debug("Connecting to {} using Azure System Assigned Identity or Azure User Assigned Identity.", (Object)endpoint);
                    ManagedIdentityCredentialBuilder micBuilder = new ManagedIdentityCredentialBuilder();
                    builder.credential((TokenCredential)micBuilder.build());
                }
                builder.endpoint(endpoint);
                clients.add(this.modifyAndBuildClient(builder, endpoint, endpoints.size() - 1));
            }
        }
        return clients;
    }

    private AppConfigurationReplicaClient modifyAndBuildClient(ConfigurationClientBuilder builder, String endpoint, Integer replicaCount) {
        TracingInfo tracingInfo = new TracingInfo(this.isDev, this.isKeyVaultConfigured, replicaCount, Configuration.getGlobalConfiguration());
        builder.addPolicy((HttpPipelinePolicy)new BaseAppConfigurationPolicy(tracingInfo));
        if (this.clientProvider != null) {
            this.clientProvider.customize(builder, endpoint);
        }
        return new AppConfigurationReplicaClient(endpoint, builder.buildClient(), tracingInfo);
    }

    public void setEnvironment(Environment environment) {
        for (String profile : environment.getActiveProfiles()) {
            if (!"dev".equalsIgnoreCase(profile)) continue;
            this.isDev = true;
            break;
        }
        this.env = environment;
    }

    protected ConfigurationClientBuilder createBuilderInstance() {
        ExponentialBackoff retryStatagy = null;
        String mode = this.env.getProperty("spring.cloud.azure.retry.mode");
        String modeService = this.env.getProperty("spring.cloud.azure.appconfiguration.retry.mode");
        if ("exponential".equals(mode) || "exponential".equals(modeService) || mode == null && modeService == null) {
            Function<String, Integer> checkPropertyInt = parameter -> Integer.parseInt(parameter);
            Function<String, Duration> checkPropertyDuration = parameter -> DurationStyle.detectAndParse((String)parameter);
            int retries = this.checkProperty(MAX_RETRIES_PROPERTY_NAME, this.defaultMaxRetries, " isn't a valid integer, using default value.", checkPropertyInt);
            Duration baseDelay = this.checkProperty(BASE_DELAY_PROPERTY_NAME, DEFAULT_MIN_RETRY_POLICY, " isn't a valid Duration, using default value.", checkPropertyDuration);
            Duration maxDelay = this.checkProperty(MAX_DELAY_PROPERTY_NAME, DEFAULT_MAX_RETRY_POLICY, " isn't a valid Duration, using default value.", checkPropertyDuration);
            retryStatagy = new ExponentialBackoff(retries, baseDelay, maxDelay);
        }
        ConfigurationClientBuilder builder = (ConfigurationClientBuilder)this.clientFactory.build();
        if (retryStatagy != null) {
            builder.retryPolicy((HttpPipelinePolicy)new RetryPolicy(retryStatagy));
        }
        return builder;
    }

    private <T> T checkProperty(String propertyName, T defaultValue, String errMsg, Function<String, T> fn) {
        String envValue = System.getProperty("spring.cloud.azure." + propertyName);
        String envServiceValue = System.getProperty("spring.cloud.azure.appconfiguration." + propertyName);
        T value = defaultValue;
        if (envServiceValue != null) {
            try {
                value = fn.apply(envServiceValue);
            }
            catch (Exception e) {
                LOGGER.warn("{}.{} {}", new Object[]{"spring.cloud.azure.appconfiguration", propertyName, errMsg});
            }
        } else if (envValue != null) {
            try {
                value = fn.apply(envValue);
            }
            catch (Exception e) {
                LOGGER.warn("{}.{} {}", new Object[]{"spring.cloud.azure", propertyName, errMsg});
            }
        }
        return value;
    }

    private static class ConnectionStringConnector
    implements ServiceConnectionStringProvider<AzureServiceType.AppConfiguration> {
        private final String connectionString;

        ConnectionStringConnector(String connectionString) {
            this.connectionString = connectionString;
        }

        public String getConnectionString() {
            return this.connectionString;
        }

        public AzureServiceType.AppConfiguration getServiceType() {
            return null;
        }
    }
}

