/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.SecretReferenceConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationKeyVaultClientFactory;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationPropertySource;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.JsonConfigurationParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

final class AppConfigurationApplicationSettingPropertySource
extends AppConfigurationPropertySource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationApplicationSettingPropertySource.class);
    private final AppConfigurationKeyVaultClientFactory keyVaultClientFactory;
    private final int maxRetryTime;

    AppConfigurationApplicationSettingPropertySource(String originEndpoint, AppConfigurationReplicaClient replicaClient, AppConfigurationKeyVaultClientFactory keyVaultClientFactory, String keyFilter, String[] labelFilter, int maxRetryTime) {
        super(originEndpoint, replicaClient, keyFilter, labelFilter);
        this.keyVaultClientFactory = keyVaultClientFactory;
        this.maxRetryTime = maxRetryTime;
    }

    public void initProperties() throws JsonProcessingException {
        List<String> labels = Arrays.asList(this.labelFilter);
        Collections.reverse(labels);
        for (String label : labels) {
            SettingSelector settingSelector = new SettingSelector().setKeyFilter(this.keyFilter + "*").setLabelFilter(label);
            List<ConfigurationSetting> settings = this.replicaClient.listSettings(settingSelector);
            for (ConfigurationSetting setting : settings) {
                String key = setting.getKey().trim().substring(this.keyFilter.length()).replace('/', '.');
                if (setting instanceof SecretReferenceConfigurationSetting) {
                    String entry = this.getKeyVaultEntry((SecretReferenceConfigurationSetting)setting);
                    if (entry == null) continue;
                    this.properties.put(key, entry);
                    continue;
                }
                if (StringUtils.hasText((String)setting.getContentType()) && JsonConfigurationParser.isJsonContentType(setting.getContentType())) {
                    Map<String, Object> jsonSettings = JsonConfigurationParser.parseJsonSetting(setting);
                    for (Map.Entry<String, Object> jsonSetting : jsonSettings.entrySet()) {
                        key = jsonSetting.getKey().trim().substring(this.keyFilter.length());
                        this.properties.put(key, jsonSetting.getValue());
                    }
                    continue;
                }
                this.properties.put(key, setting.getValue());
            }
        }
    }

    private String getKeyVaultEntry(SecretReferenceConfigurationSetting secretReference) {
        String secretValue = null;
        try {
            URI uri = null;
            KeyVaultSecret secret = null;
            try {
                uri = new URI(secretReference.getSecretId());
                secret = this.keyVaultClientFactory.getClient("https://" + uri.getHost()).getSecret(uri, this.maxRetryTime);
            }
            catch (URISyntaxException e) {
                LOGGER.error("Error Processing Key Vault Entry URI.");
                ReflectionUtils.rethrowRuntimeException((Throwable)e);
            }
            if (secret == null) {
                throw new IOException("No Key Vault Secret found for Reference.");
            }
            secretValue = secret.getValue();
        }
        catch (IOException | RuntimeException e) {
            LOGGER.error("Error Retrieving Key Vault Entry");
            ReflectionUtils.rethrowRuntimeException((Throwable)e);
        }
        return secretValue;
    }
}

