/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation.http.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.spring.cloud.appconfiguration.config.implementation.RequestTracingConstants;
import com.azure.spring.cloud.appconfiguration.config.implementation.http.policy.TracingInfo;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public final class BaseAppConfigurationPolicy
implements HttpPipelinePolicy {
    private static final String PACKAGE_NAME = BaseAppConfigurationPolicy.class.getPackage().getImplementationTitle();
    public static final String USER_AGENT = String.format("%s/%s", StringUtils.replace((String)PACKAGE_NAME, (String)" ", (String)""), BaseAppConfigurationPolicy.class.getPackage().getImplementationVersion());
    static Boolean watchRequests = false;
    final TracingInfo tracingInfo;

    public BaseAppConfigurationPolicy(TracingInfo tracingInfo) {
        this.tracingInfo = tracingInfo;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        String sdkUserAgent = context.getHttpRequest().getHeaders().get("User-Agent").getValue();
        context.getHttpRequest().getHeaders().set("User-Agent", USER_AGENT + " " + sdkUserAgent);
        context.getHttpRequest().getHeaders().set(RequestTracingConstants.CORRELATION_CONTEXT_HEADER.toString(), this.tracingInfo.getValue(watchRequests));
        return next.process();
    }

    public static void setWatchRequests(Boolean watchRequests) {
        BaseAppConfigurationPolicy.watchRequests = watchRequests;
    }
}

