/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.data.appconfiguration.models.FeatureFlagConfigurationSetting;
import com.azure.data.appconfiguration.models.SettingSelector;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationPullRefresh;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClientFactory;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationStatusException;
import com.azure.spring.cloud.appconfiguration.config.implementation.ConnectionManager;
import com.azure.spring.cloud.appconfiguration.config.implementation.State;
import com.azure.spring.cloud.appconfiguration.config.implementation.StateHolder;
import com.azure.spring.cloud.appconfiguration.config.implementation.http.policy.BaseAppConfigurationPolicy;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.AppConfigurationStoreMonitoring;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.FeatureFlagKeyValueSelector;
import com.azure.spring.cloud.appconfiguration.config.implementation.properties.FeatureFlagStore;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

class AppConfigurationRefreshUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppConfigurationPullRefresh.class);

    AppConfigurationRefreshUtil() {
    }

    static RefreshEventData refreshStoresCheck(AppConfigurationReplicaClientFactory clientFactory, Duration refreshInterval, List<String> profiles, Long defaultMinBackoff) {
        RefreshEventData eventData = new RefreshEventData();
        BaseAppConfigurationPolicy.setWatchRequests(true);
        try {
            if (refreshInterval != null && StateHolder.getNextForcedRefresh() != null && Instant.now().isAfter(StateHolder.getNextForcedRefresh())) {
                String eventDataInfo = "Minimum refresh period reached. Refreshing configurations.";
                LOGGER.info(eventDataInfo);
                eventData.setFullMessage(eventDataInfo);
                return eventData;
            }
            block6: for (Map.Entry<String, ConnectionManager> entry : clientFactory.getConnections().entrySet()) {
                String originEndpoint = entry.getKey();
                ConnectionManager connection = entry.getValue();
                clientFactory.setCurrentConfigStoreClient(originEndpoint, originEndpoint);
                AppConfigurationStoreMonitoring monitor = connection.getMonitoring();
                List<AppConfigurationReplicaClient> clients = clientFactory.getAvailableClients(originEndpoint);
                if (monitor.isEnabled() && StateHolder.getLoadState(originEndpoint)) {
                    for (AppConfigurationReplicaClient client : clients) {
                        try {
                            AppConfigurationRefreshUtil.refreshWithTime(client, StateHolder.getState(originEndpoint), monitor.getRefreshInterval(), eventData);
                            if (eventData.getDoRefresh()) {
                                clientFactory.setCurrentConfigStoreClient(originEndpoint, client.getEndpoint());
                                return eventData;
                            }
                            break;
                        }
                        catch (AppConfigurationStatusException e) {
                            LOGGER.warn("Failed attempting to connect to " + client.getEndpoint() + " during refresh check.");
                            clientFactory.backoffClientClient(originEndpoint, client.getEndpoint());
                        }
                    }
                } else {
                    LOGGER.debug("Skipping configuration refresh check for " + originEndpoint);
                }
                FeatureFlagStore featureStore = connection.getFeatureFlagStore();
                if (featureStore.getEnabled().booleanValue() && StateHolder.getLoadStateFeatureFlag(originEndpoint)) {
                    for (AppConfigurationReplicaClient client : clients) {
                        try {
                            AppConfigurationRefreshUtil.refreshWithTimeFeatureFlags(client, featureStore, StateHolder.getStateFeatureFlag(originEndpoint), monitor.getFeatureFlagRefreshInterval(), eventData, profiles);
                            if (!eventData.getDoRefresh()) continue block6;
                            clientFactory.setCurrentConfigStoreClient(originEndpoint, client.getEndpoint());
                            return eventData;
                        }
                        catch (AppConfigurationStatusException e) {
                            LOGGER.warn("Failed attempting to connect to " + client.getEndpoint() + " during refresh check.");
                            clientFactory.backoffClientClient(originEndpoint, client.getEndpoint());
                        }
                    }
                    continue;
                }
                LOGGER.debug("Skipping feature flag refresh check for " + originEndpoint);
            }
        }
        catch (Exception e) {
            StateHolder.getCurrentState().updateNextRefreshTime(refreshInterval, defaultMinBackoff);
            throw e;
        }
        return eventData;
    }

    static boolean checkStoreAfterRefreshFailed(AppConfigurationReplicaClient client, AppConfigurationReplicaClientFactory clientFactory, FeatureFlagStore featureStore, List<String> profiles) {
        return AppConfigurationRefreshUtil.refreshStoreCheck(client, clientFactory.findOriginForEndpoint(client.getEndpoint())) || AppConfigurationRefreshUtil.refreshStoreFeatureFlagCheck(featureStore, client, profiles);
    }

    private static boolean refreshStoreCheck(AppConfigurationReplicaClient client, String originEndpoint) {
        RefreshEventData eventData = new RefreshEventData();
        if (StateHolder.getLoadState(originEndpoint)) {
            AppConfigurationRefreshUtil.refreshWithoutTime(client, StateHolder.getState(originEndpoint).getWatchKeys(), eventData);
        }
        return eventData.getDoRefresh();
    }

    private static boolean refreshStoreFeatureFlagCheck(FeatureFlagStore featureStore, AppConfigurationReplicaClient client, List<String> profiles) {
        RefreshEventData eventData = new RefreshEventData();
        String endpoint = client.getEndpoint();
        if (featureStore.getEnabled().booleanValue() && StateHolder.getLoadStateFeatureFlag(endpoint)) {
            AppConfigurationRefreshUtil.refreshWithoutTimeFeatureFlags(client, featureStore, StateHolder.getStateFeatureFlag(endpoint).getWatchKeys(), eventData, profiles);
        } else {
            LOGGER.debug("Skipping feature flag refresh check for " + endpoint);
        }
        return eventData.getDoRefresh();
    }

    private static void refreshWithTime(AppConfigurationReplicaClient client, State state, Duration refreshInterval, RefreshEventData eventData) throws AppConfigurationStatusException {
        if (Instant.now().isAfter(state.getNextRefreshCheck())) {
            AppConfigurationRefreshUtil.refreshWithoutTime(client, state.getWatchKeys(), eventData);
            StateHolder.getCurrentState().updateStateRefresh(state, refreshInterval);
        }
    }

    private static void refreshWithoutTime(AppConfigurationReplicaClient client, List<ConfigurationSetting> watchKeys, RefreshEventData eventData) throws AppConfigurationStatusException {
        for (ConfigurationSetting watchKey : watchKeys) {
            ConfigurationSetting watchedKey = client.getWatchKey(watchKey.getKey(), watchKey.getLabel());
            if (watchedKey == null) continue;
            AppConfigurationRefreshUtil.checkETag(watchKey, watchedKey, client.getEndpoint(), eventData);
            if (!eventData.getDoRefresh()) continue;
            break;
        }
    }

    private static void refreshWithTimeFeatureFlags(AppConfigurationReplicaClient client, FeatureFlagStore featureStore, State state, Duration refreshInterval, RefreshEventData eventData, List<String> profiles) throws AppConfigurationStatusException {
        Instant date = Instant.now();
        if (date.isAfter(state.getNextRefreshCheck())) {
            int watchedKeySize = 0;
            for (FeatureFlagKeyValueSelector watchKey : featureStore.getSelects()) {
                Object keyFilter = ".appconfig.featureflag/*";
                if (StringUtils.hasText((String)watchKey.getKeyFilter())) {
                    keyFilter = ".appconfig.featureflag/" + watchKey.getKeyFilter();
                }
                SettingSelector selector = new SettingSelector().setKeyFilter((String)keyFilter).setLabelFilter(watchKey.getLabelFilterText(profiles));
                List<ConfigurationSetting> currentKeys = client.listSettings(selector);
                watchedKeySize += AppConfigurationRefreshUtil.checkFeatureFlags(currentKeys, state, client, eventData);
            }
            if (!eventData.getDoRefresh() && watchedKeySize != state.getWatchKeys().size()) {
                String eventDataInfo = ".appconfig.featureflag/*";
                LOGGER.info("Configuration Refresh Event triggered by " + eventDataInfo);
                eventData.setMessage(eventDataInfo);
            }
            StateHolder.getCurrentState().updateStateRefresh(state, refreshInterval);
        }
    }

    private static int checkFeatureFlags(List<ConfigurationSetting> currentKeys, State state, AppConfigurationReplicaClient client, RefreshEventData eventData) {
        int watchedKeySize = 0;
        for (ConfigurationSetting currentKey : currentKeys) {
            if (!(currentKey instanceof FeatureFlagConfigurationSetting) || !"application/vnd.microsoft.appconfig.ff+json;charset=utf-8".equals(currentKey.getContentType())) continue;
            ++watchedKeySize;
            for (ConfigurationSetting watchFlag : state.getWatchKeys()) {
                if (!AppConfigurationRefreshUtil.compairKeys(watchFlag, currentKey, client.getEndpoint(), eventData).booleanValue() || !eventData.getDoRefresh()) continue;
                return watchedKeySize;
            }
        }
        return watchedKeySize;
    }

    private static void refreshWithoutTimeFeatureFlags(AppConfigurationReplicaClient client, FeatureFlagStore featureStore, List<ConfigurationSetting> watchKeys, RefreshEventData eventData, List<String> profiles) throws AppConfigurationStatusException {
        for (FeatureFlagKeyValueSelector watchKey : featureStore.getSelects()) {
            Object keyFilter = ".appconfig.featureflag/*";
            if (StringUtils.hasText((String)watchKey.getKeyFilter())) {
                keyFilter = ".appconfig.featureflag/" + watchKey.getKeyFilter();
            }
            SettingSelector selector = new SettingSelector().setKeyFilter((String)keyFilter).setLabelFilter(watchKey.getLabelFilterText(profiles));
            List<ConfigurationSetting> currentTriggerConfigurations = client.listSettings(selector);
            int watchedKeySize = 0;
            for (ConfigurationSetting currentTriggerConfiguration : currentTriggerConfigurations) {
                ++watchedKeySize;
                for (ConfigurationSetting watchFlag : watchKeys) {
                    if (!AppConfigurationRefreshUtil.compairKeys(watchFlag, currentTriggerConfiguration, client.getEndpoint(), eventData).booleanValue()) break;
                    if (!eventData.getDoRefresh()) continue;
                    return;
                }
            }
            if (watchedKeySize == watchKeys.size()) continue;
            String eventDataInfo = ".appconfig.featureflag/*";
            LOGGER.info("Configuration Refresh Event triggered by " + eventDataInfo);
            eventData.setMessage(eventDataInfo);
        }
    }

    private static Boolean compairKeys(ConfigurationSetting key1, ConfigurationSetting key2, String endpoint, RefreshEventData eventData) {
        if (key1 != null && key1.getKey().equals(key2.getKey()) && key1.getLabel().equals(key2.getLabel())) {
            AppConfigurationRefreshUtil.checkETag(key1, key2, endpoint, eventData);
            return true;
        }
        return false;
    }

    private static void checkETag(ConfigurationSetting watchSetting, ConfigurationSetting currentTriggerConfiguration, String endpoint, RefreshEventData eventData) {
        if (currentTriggerConfiguration == null) {
            return;
        }
        LOGGER.debug(watchSetting.getETag(), (Object)" - ", (Object)currentTriggerConfiguration.getETag());
        if (watchSetting.getETag() != null && !watchSetting.getETag().equals(currentTriggerConfiguration.getETag())) {
            LOGGER.trace("Some keys in store [{}] matching the key [{}] and label [{}] is updated, will send refresh event.", new Object[]{endpoint, watchSetting.getKey(), watchSetting.getLabel()});
            String eventDataInfo = watchSetting.getKey();
            LOGGER.info("Configuration Refresh Event triggered by " + eventDataInfo);
            eventData.setMessage(eventDataInfo);
        }
    }

    static class RefreshEventData {
        private static final String MSG_TEMPLATE = "Some keys matching %s has been updated since last check.";
        private String message = "";
        private boolean doRefresh = false;

        RefreshEventData() {
        }

        RefreshEventData setMessage(String prefix) {
            this.setFullMessage(String.format(MSG_TEMPLATE, prefix));
            return this;
        }

        RefreshEventData setFullMessage(String message) {
            this.message = message;
            this.doRefresh = true;
            return this;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean getDoRefresh() {
            return this.doRefresh;
        }
    }
}

