/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation;

import com.azure.data.appconfiguration.ConfigurationClient;
import com.azure.data.appconfiguration.models.ConfigurationSetting;
import com.azure.spring.cloud.appconfiguration.config.implementation.AppConfigurationReplicaClient;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.env.EnumerablePropertySource;

abstract class AppConfigurationPropertySource
extends EnumerablePropertySource<ConfigurationClient> {
    protected final Map<String, Object> properties = new LinkedHashMap<String, Object>();
    protected final List<ConfigurationSetting> featureConfigurationSettings = new ArrayList<ConfigurationSetting>();
    protected final AppConfigurationReplicaClient replicaClient;

    AppConfigurationPropertySource(String name, AppConfigurationReplicaClient replicaClient) {
        super(name);
        this.replicaClient = replicaClient;
    }

    public String[] getPropertyNames() {
        Set<String> keySet = this.properties.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    protected static String getLabelName(String[] labelFilters) {
        if (labelFilters == null) {
            return "";
        }
        return String.join((CharSequence)",", labelFilters);
    }

    protected abstract void initProperties(List<String> var1) throws JsonProcessingException;
}

