/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.appconfiguration.config.implementation.http.policy;

import com.azure.core.util.Configuration;
import com.azure.spring.cloud.appconfiguration.config.implementation.HostType;
import com.azure.spring.cloud.appconfiguration.config.implementation.RequestTracingConstants;
import com.azure.spring.cloud.appconfiguration.config.implementation.RequestType;
import com.azure.spring.cloud.appconfiguration.config.implementation.http.policy.FeatureFlagTracing;

public class TracingInfo {
    private boolean isDev = false;
    private boolean isKeyVaultConfigured = false;
    private int replicaCount;
    private final FeatureFlagTracing featureFlagTracing;
    private final Configuration configuration;

    public TracingInfo(boolean isDev, boolean isKeyVaultConfigured, int replicaCount, Configuration configuration) {
        this.isDev = isDev;
        this.isKeyVaultConfigured = isKeyVaultConfigured;
        this.replicaCount = replicaCount;
        this.featureFlagTracing = new FeatureFlagTracing();
        this.configuration = configuration;
    }

    public String getValue(boolean watchRequests) {
        String hostType;
        String track = this.configuration.get(RequestTracingConstants.REQUEST_TRACING_DISABLED_ENVIRONMENT_VARIABLE.toString());
        if (track != null && Boolean.valueOf(track).booleanValue()) {
            return "";
        }
        RequestType requestTypeValue = watchRequests ? RequestType.WATCH : RequestType.STARTUP;
        StringBuilder sb = new StringBuilder();
        sb.append((Object)RequestTracingConstants.REQUEST_TYPE_KEY).append("=" + String.valueOf((Object)requestTypeValue));
        if (this.featureFlagTracing != null && this.featureFlagTracing.usesAnyFilter()) {
            sb.append(",Filter=").append(this.featureFlagTracing.toString());
        }
        if (!(hostType = TracingInfo.getHostType()).isEmpty()) {
            sb.append(",").append((Object)RequestTracingConstants.HOST_TYPE_KEY).append("=").append(hostType);
        }
        if (this.isDev) {
            sb.append(",Env=").append("Dev");
        }
        if (this.isKeyVaultConfigured) {
            sb.append(",").append("UsesKeyVault");
        }
        if (this.replicaCount > 0) {
            sb.append(",").append((Object)RequestTracingConstants.REPLICA_COUNT).append("=").append(this.replicaCount);
        }
        return sb.toString();
    }

    private static String getHostType() {
        HostType hostType = HostType.UNIDENTIFIED;
        if (System.getenv(RequestTracingConstants.AZURE_FUNCTIONS_ENVIRONMENT_VARIABLE.toString()) != null) {
            hostType = HostType.AZURE_FUNCTION;
        } else if (System.getenv(RequestTracingConstants.AZURE_WEB_APP_ENVIRONMENT_VARIABLE.toString()) != null) {
            hostType = HostType.AZURE_WEB_APP;
        } else if (System.getenv(RequestTracingConstants.KUBERNETES_ENVIRONMENT_VARIABLE.toString()) != null) {
            hostType = HostType.KUBERNETES;
        } else if (System.getenv(RequestTracingConstants.CONTAINER_APP_ENVIRONMENT_VARIABLE.toString()) != null) {
            hostType = HostType.CONTAINER_APP;
        }
        return hostType.toString();
    }

    public FeatureFlagTracing getFeatureFlagTracing() {
        return this.featureFlagTracing;
    }
}

