/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.b2c.implementation;

import com.azure.spring.cloud.autoconfigure.aad.b2c.implementation.AADB2CProperties;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.CollectionUtils;

public final class AADB2CConditions {
    private static AADB2CProperties getAADB2CProperties(ConditionContext context) {
        return (AADB2CProperties)Binder.get((Environment)context.getEnvironment()).bind("spring.cloud.azure.active-directory.b2c", AADB2CProperties.class).orElse(null);
    }

    private static String getConditionResult(String name, Map<String, ?> map) {
        return name + ": " + String.join((CharSequence)", ", map.keySet()) + " ";
    }

    static final class UserFlowCondition
    extends SpringBootCondition {
        UserFlowCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"AAD B2C User Flow Clients Configured Condition", (Object[])new Object[0]);
            AADB2CProperties aadb2CProperties = AADB2CConditions.getAADB2CProperties(context);
            if (aadb2CProperties == null) {
                return ConditionOutcome.noMatch((ConditionMessage)message.notAvailable("aad b2c properties"));
            }
            if (CollectionUtils.isEmpty(aadb2CProperties.getUserFlows())) {
                return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("user flows").atAll());
            }
            return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)AADB2CConditions.getConditionResult("user-flows", aadb2CProperties.getUserFlows())));
        }
    }

    static final class ClientRegistrationCondition
    extends SpringBootCondition {
        ClientRegistrationCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ConditionMessage.Builder message = ConditionMessage.forCondition((String)"AAD B2C OAuth 2.0 Clients Configured Condition", (Object[])new Object[0]);
            AADB2CProperties aadb2CProperties = AADB2CConditions.getAADB2CProperties(context);
            if (aadb2CProperties == null) {
                return ConditionOutcome.noMatch((ConditionMessage)message.notAvailable("aad b2c properties"));
            }
            if (CollectionUtils.isEmpty(aadb2CProperties.getUserFlows()) && CollectionUtils.isEmpty(aadb2CProperties.getAuthorizationClients())) {
                return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("registered clients").items(new Object[]{"user-flows", "authorization-clients"}));
            }
            StringBuilder details = new StringBuilder();
            if (!CollectionUtils.isEmpty(aadb2CProperties.getUserFlows())) {
                details.append(AADB2CConditions.getConditionResult("user-flows", aadb2CProperties.getUserFlows()));
            }
            if (!CollectionUtils.isEmpty(aadb2CProperties.getAuthorizationClients())) {
                details.append(AADB2CConditions.getConditionResult("authorization-clients", aadb2CProperties.getAuthorizationClients()));
            }
            return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)details.toString()));
        }
    }

    static final class CommonCondition
    extends AnyNestedCondition {
        CommonCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnWebApplication
        @ConditionalOnProperty(prefix="spring.cloud.azure.active-directory.b2c", value={"tenant-id"})
        static class WebApiMode {
            WebApiMode() {
            }
        }

        @ConditionalOnWebApplication
        @ConditionalOnProperty(prefix="spring.cloud.azure.active-directory.b2c", value={"client-id", "client-secret"})
        static class WebAppMode {
            WebAppMode() {
            }
        }
    }
}

