/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.core;

import org.springframework.util.ClassUtils;

public enum AADApplicationType {
    WEB_APPLICATION("web_application"),
    RESOURCE_SERVER("resource_server"),
    RESOURCE_SERVER_WITH_OBO("resource_server_with_obo"),
    WEB_APPLICATION_AND_RESOURCE_SERVER("web_application_and_resource_server");

    private final String applicationType;
    public static final String SPRING_SECURITY_OAUTH2_CLIENT_CLASS_NAME = "org.springframework.security.oauth2.client.registration.ClientRegistration";
    public static final String SPRING_SECURITY_OAUTH2_RESOURCE_SERVER_CLASS_NAME = "org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken";

    private AADApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String getValue() {
        return this.applicationType;
    }

    public static AADApplicationType inferApplicationTypeByDependencies() {
        AADApplicationType type = AADApplicationType.isOAuth2ClientAvailable() ? (AADApplicationType.isResourceServerAvailable() ? RESOURCE_SERVER_WITH_OBO : WEB_APPLICATION) : (AADApplicationType.isResourceServerAvailable() ? RESOURCE_SERVER : null);
        return type;
    }

    private static boolean isOAuth2ClientAvailable() {
        return AADApplicationType.isPresent(SPRING_SECURITY_OAUTH2_CLIENT_CLASS_NAME);
    }

    private static boolean isResourceServerAvailable() {
        return AADApplicationType.isPresent(SPRING_SECURITY_OAUTH2_RESOURCE_SERVER_CLASS_NAME);
    }

    private static boolean isPresent(String className) {
        return ClassUtils.isPresent((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader());
    }
}

