/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.filter;

import com.azure.spring.cloud.autoconfigure.aad.filter.UserPrincipal;
import com.azure.spring.cloud.autoconfigure.aad.filter.UserPrincipalManager;
import com.azure.spring.cloud.autoconfigure.aad.implementation.constants.Constants;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.proc.BadJWTException;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@Deprecated
public class AADAppRoleStatelessAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AADAppRoleStatelessAuthenticationFilter.class);
    private final UserPrincipalManager principalManager;

    public AADAppRoleStatelessAuthenticationFilter(UserPrincipalManager principalManager) {
        this.principalManager = principalManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        String aadIssuedBearerToken = Optional.of(httpServletRequest).map(r -> r.getHeader("Authorization")).map(String::trim).filter(s -> s.startsWith("Bearer ")).map(s -> s.replace("Bearer ", "")).filter(this.principalManager::isTokenIssuedByAAD).orElse(null);
        if (aadIssuedBearerToken == null || this.alreadyAuthenticated()) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        try {
            UserPrincipal userPrincipal = this.principalManager.buildUserPrincipal(aadIssuedBearerToken);
            PreAuthenticatedAuthenticationToken authentication = new PreAuthenticatedAuthenticationToken((Object)userPrincipal, null, this.toSimpleGrantedAuthoritySet(userPrincipal));
            LOGGER.info("Request token verification success. {}", (Object)authentication);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            try {
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            finally {
                SecurityContextHolder.clearContext();
            }
        }
        catch (BadJWTException ex) {
            httpServletResponse.sendError(HttpStatus.UNAUTHORIZED.value());
        }
        catch (JOSEException | BadJOSEException | ParseException ex) {
            LOGGER.error("Failed to initialize UserPrincipal.", ex);
            throw new ServletException(ex);
        }
    }

    private boolean alreadyAuthenticated() {
        return Optional.of(SecurityContextHolder.getContext()).map(SecurityContext::getAuthentication).map(Authentication::isAuthenticated).orElse(false);
    }

    protected Set<SimpleGrantedAuthority> toSimpleGrantedAuthoritySet(UserPrincipal userPrincipal) {
        Set simpleGrantedAuthoritySet = Optional.of(userPrincipal).map(UserPrincipal::getRoles).map(Collection::stream).orElseGet(Stream::empty).filter(StringUtils::hasText).map(s -> new SimpleGrantedAuthority("ROLE_" + s)).collect(Collectors.toSet());
        return Optional.of(simpleGrantedAuthoritySet).filter(r -> !r.isEmpty()).orElse(Constants.DEFAULT_AUTHORITY_SET);
    }
}

