/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.filter;

import com.azure.spring.cloud.autoconfigure.aad.core.AADAuthorizationServerEndpoints;
import com.azure.spring.cloud.autoconfigure.aad.filter.AADAppRoleStatelessAuthenticationFilter;
import com.azure.spring.cloud.autoconfigure.aad.filter.AADAuthenticationFilter;
import com.azure.spring.cloud.autoconfigure.aad.filter.UserPrincipalManager;
import com.azure.spring.cloud.autoconfigure.aad.properties.AADAuthenticationProperties;
import com.nimbusds.jose.jwk.source.DefaultJWKSetCache;
import com.nimbusds.jose.jwk.source.JWKSetCache;
import com.nimbusds.jose.util.DefaultResourceRetriever;
import com.nimbusds.jose.util.ResourceRetriever;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnExpression(value="${spring.cloud.azure.active-directory.enabled:false}")
@ConditionalOnMissingClass(value={"org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken"})
@ConditionalOnProperty(prefix="spring.cloud.azure.active-directory", value={"client-id"})
@EnableConfigurationProperties(value={AADAuthenticationProperties.class})
public class AADAuthenticationFilterAutoConfiguration {
    public static final String PROPERTY_PREFIX = "spring.cloud.azure.active-directory";
    private static final Logger LOG = LoggerFactory.getLogger(AADAuthenticationProperties.class);
    private final AADAuthenticationProperties properties;
    private final AADAuthorizationServerEndpoints endpoints;

    public AADAuthenticationFilterAutoConfiguration(AADAuthenticationProperties properties) {
        this.properties = properties;
        this.endpoints = new AADAuthorizationServerEndpoints(properties.getBaseUri(), properties.getTenantId());
    }

    @Bean
    @ConditionalOnMissingBean(value={AADAuthenticationFilter.class})
    @ConditionalOnExpression(value="${spring.cloud.azure.active-directory.session-stateless:false} == false")
    @ConditionalOnProperty(prefix="spring.cloud.azure.active-directory", value={"client-id", "client-secret"})
    public AADAuthenticationFilter azureADJwtTokenFilter() {
        LOG.info("AzureADJwtTokenFilter Constructor.");
        return new AADAuthenticationFilter(this.properties, this.endpoints, this.getJWTResourceRetriever(), this.getJWKSetCache());
    }

    @Bean
    @ConditionalOnMissingBean(value={AADAppRoleStatelessAuthenticationFilter.class})
    @ConditionalOnExpression(value="${spring.cloud.azure.active-directory.session-stateless:false} == true")
    @ConditionalOnProperty(prefix="spring.cloud.azure.active-directory", value={"client-id"})
    public AADAppRoleStatelessAuthenticationFilter azureADStatelessAuthFilter(ResourceRetriever resourceRetriever) {
        LOG.info("Creating AzureADStatelessAuthFilter bean.");
        return new AADAppRoleStatelessAuthenticationFilter(new UserPrincipalManager(this.endpoints, this.properties, resourceRetriever, true));
    }

    @Bean
    @ConditionalOnMissingBean(value={ResourceRetriever.class})
    public ResourceRetriever getJWTResourceRetriever() {
        return new DefaultResourceRetriever(this.properties.getJwtConnectTimeout(), this.properties.getJwtReadTimeout(), this.properties.getJwtSizeLimit());
    }

    @Bean
    @ConditionalOnMissingBean(value={JWKSetCache.class})
    public JWKSetCache getJWKSetCache() {
        long lifespan = this.properties.getJwkSetCacheLifespan();
        long refreshTime = this.properties.getJwkSetCacheRefreshTime();
        return new DefaultJWKSetCache(lifespan, refreshTime, TimeUnit.MILLISECONDS);
    }
}

