/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.implementation.conditions;

import com.azure.spring.cloud.autoconfigure.aad.core.AADApplicationType;
import com.azure.spring.cloud.autoconfigure.aad.properties.AADAuthenticationProperties;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public final class ResourceServerCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)"AAD Resource Server Condition", (Object[])new Object[0]);
        AADAuthenticationProperties properties = (AADAuthenticationProperties)Binder.get((Environment)context.getEnvironment()).bind("spring.cloud.azure.active-directory", AADAuthenticationProperties.class).orElse(null);
        if (properties == null) {
            return ConditionOutcome.noMatch((ConditionMessage)message.notAvailable("aad authorization properties"));
        }
        AADApplicationType applicationType = Optional.ofNullable(properties.getApplicationType()).orElseGet(AADApplicationType::inferApplicationTypeByDependencies);
        if (applicationType == null || applicationType == AADApplicationType.WEB_APPLICATION) {
            return ConditionOutcome.noMatch((ConditionMessage)message.because("spring.cloud.azure.active-directory.application-type=" + (Object)((Object)applicationType)));
        }
        return ConditionOutcome.match((ConditionMessage)message.foundExactly((Object)("spring.cloud.azure.active-directory.application-type=" + (Object)((Object)applicationType))));
    }
}

