/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.implementation.oauth2;

import com.azure.spring.cloud.autoconfigure.aad.core.AADAuthorizationGrantType;
import com.azure.spring.cloud.autoconfigure.aad.core.AADAuthorizationServerEndpoints;
import com.azure.spring.cloud.autoconfigure.aad.properties.AADAuthenticationProperties;
import com.azure.spring.cloud.autoconfigure.aad.properties.AuthorizationClientProperties;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.util.Assert;

public class AADClientRegistrationRepository
implements ClientRegistrationRepository,
Iterable<ClientRegistration> {
    public static final String AZURE_CLIENT_REGISTRATION_ID = "azure";
    private final Set<String> azureClientAccessTokenScopes;
    private final Map<String, ClientRegistration> allClients;

    public AADClientRegistrationRepository(AADAuthenticationProperties properties) {
        Set<String> accessTokenScopes = this.azureClientAccessTokenScopes(properties);
        Set<String> delegatedScopes = this.delegatedClientsAccessTokenScopes(properties);
        HashSet<String> authorizationCodeScopes = new HashSet<String>();
        authorizationCodeScopes.addAll(accessTokenScopes);
        authorizationCodeScopes.addAll(delegatedScopes);
        if (AADClientRegistrationRepository.resourceServerCount(accessTokenScopes) == 0 && AADClientRegistrationRepository.resourceServerCount(authorizationCodeScopes) > 1) {
            String newScope = properties.getGraphBaseUri() + "User.Read";
            accessTokenScopes.add(newScope);
            authorizationCodeScopes.add(newScope);
        }
        this.azureClientAccessTokenScopes = accessTokenScopes;
        this.allClients = properties.getAuthorizationClients().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.toClientRegistration((String)entry.getKey(), ((AuthorizationClientProperties)entry.getValue()).getAuthorizationGrantType(), ((AuthorizationClientProperties)entry.getValue()).getScopes(), properties)));
        ClientRegistration azureClient = this.toClientRegistration(AZURE_CLIENT_REGISTRATION_ID, AADAuthorizationGrantType.AUTHORIZATION_CODE, authorizationCodeScopes, properties);
        this.allClients.put(AZURE_CLIENT_REGISTRATION_ID, azureClient);
    }

    public Set<String> getAzureClientAccessTokenScopes() {
        return this.azureClientAccessTokenScopes;
    }

    public ClientRegistration findByRegistrationId(String registrationId) {
        Assert.hasText((String)registrationId, (String)"registrationId cannot be empty");
        return this.allClients.get(registrationId);
    }

    @Override
    public Iterator<ClientRegistration> iterator() {
        return this.allClients.values().stream().filter(client -> client.getAuthorizationGrantType().getValue().equals(AADAuthorizationGrantType.AUTHORIZATION_CODE.getValue())).iterator();
    }

    private Set<String> azureClientAccessTokenScopes(AADAuthenticationProperties properties) {
        Set result = Optional.of(properties).map(AADAuthenticationProperties::getAuthorizationClients).map(clients -> (AuthorizationClientProperties)clients.get(AZURE_CLIENT_REGISTRATION_ID)).map(AuthorizationClientProperties::getScopes).map(HashSet::new).orElseGet(HashSet::new);
        if (!result.contains("openid")) {
            result.add("openid");
        }
        if (!result.contains("profile")) {
            result.add("profile");
        }
        if (!result.contains("offline_access")) {
            result.add("offline_access");
        }
        if (properties.allowedGroupNamesConfigured()) {
            result.add(properties.getGraphBaseUri() + "Directory.Read.All");
        } else if (properties.allowedGroupIdsConfigured()) {
            result.add(properties.getGraphBaseUri() + "User.Read");
        }
        return result;
    }

    private Set<String> delegatedClientsAccessTokenScopes(AADAuthenticationProperties properties) {
        return properties.getAuthorizationClients().values().stream().filter(p -> AADAuthorizationGrantType.AZURE_DELEGATED.getValue().equals(p.getAuthorizationGrantType().getValue())).flatMap(p -> p.getScopes().stream()).collect(Collectors.toSet());
    }

    private ClientRegistration toClientRegistration(String registrationId, AADAuthorizationGrantType aadAuthorizationGrantType, Collection<String> scopes, AADAuthenticationProperties properties) {
        AADAuthorizationServerEndpoints endpoints = new AADAuthorizationServerEndpoints(properties.getBaseUri(), properties.getTenantId());
        return ClientRegistration.withRegistrationId((String)registrationId).clientName(registrationId).authorizationGrantType(new AuthorizationGrantType(aadAuthorizationGrantType.getValue())).scope(scopes).redirectUri(properties.getRedirectUriTemplate()).userNameAttributeName(properties.getUserNameAttribute()).clientId(properties.getClientId()).clientSecret(properties.getClientSecret()).authorizationUri(endpoints.authorizationEndpoint()).tokenUri(endpoints.tokenEndpoint()).jwkSetUri(endpoints.jwkSetEndpoint()).providerConfigurationMetadata(this.providerConfigurationMetadata(endpoints)).build();
    }

    private Map<String, Object> providerConfigurationMetadata(AADAuthorizationServerEndpoints endpoints) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        String endSessionEndpoint = endpoints.endSessionEndpoint();
        result.put("end_session_endpoint", endSessionEndpoint);
        return result;
    }

    public static int resourceServerCount(Set<String> scopes) {
        return (int)scopes.stream().filter(scope -> scope.contains("/")).map(scope -> scope.substring(0, scope.lastIndexOf(47))).distinct().count();
    }
}

