/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.webapi.validator;

import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;

public final class AADJwtClaimValidator<T>
implements OAuth2TokenValidator<Jwt> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AADJwtClaimValidator.class);
    private final String claim;
    private final OAuth2Error error;
    private final Predicate<T> test;

    public AADJwtClaimValidator(String claim, Predicate<T> test) {
        Assert.notNull((Object)claim, (String)"claim can not be null");
        Assert.notNull(test, (String)"test can not be null");
        this.claim = claim;
        this.test = test;
        this.error = new OAuth2Error("invalid_request", "The " + this.claim + " claim is not valid", "https://tools.ietf.org/html/rfc6750#section-3.1");
    }

    public OAuth2TokenValidatorResult validate(Jwt token) {
        Assert.notNull((Object)token, (String)"token cannot be null");
        Object claimValue = token.getClaim(this.claim);
        if (this.test.test(claimValue)) {
            return OAuth2TokenValidatorResult.success();
        }
        LOGGER.debug(this.error.getDescription());
        return OAuth2TokenValidatorResult.failure((OAuth2Error[])new OAuth2Error[]{this.error});
    }
}

