/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.webapp;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.oauth2.client.ClientAuthorizationRequiredException;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.reactive.function.client.WebClientResponseException;

public class AADHandleConditionalAccessFilter
extends OncePerRequestFilter {
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception exception) {
            Map authParameters = Optional.of(exception).map(Throwable::getCause).filter(e -> e instanceof WebClientResponseException).map(e -> (WebClientResponseException)e).map(WebClientResponseException::getHeaders).map(httpHeaders -> httpHeaders.get((Object)"WWW-Authenticate")).map(list -> (String)list.get(0)).map(this::parseAuthParameters).orElse(null);
            if (authParameters != null && authParameters.containsKey("CONDITIONAL_ACCESS_POLICY_CLAIMS")) {
                request.getSession().setAttribute("CONDITIONAL_ACCESS_POLICY_CLAIMS", authParameters.get("CONDITIONAL_ACCESS_POLICY_CLAIMS"));
                throw new ClientAuthorizationRequiredException("azure");
            }
            throw exception;
        }
    }

    private Map<String, String> parseAuthParameters(String wwwAuthenticateHeader) {
        return Stream.of(wwwAuthenticateHeader).filter(header -> StringUtils.hasText((String)header)).filter(header -> header.startsWith("Bearer ")).map(str -> str.substring("Bearer ".length() + 1, str.length() - 1)).map(str -> str.split(", ")).flatMap(Stream::of).map(parameter -> parameter.split("=")).filter(parameter -> ((String[])parameter).length > 1).collect(Collectors.toMap(parameters -> parameters[0], parameters -> parameters[1]));
    }
}

