/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.appconfiguration;

import com.azure.data.appconfiguration.ConfigurationAsyncClient;
import com.azure.data.appconfiguration.ConfigurationClient;
import com.azure.data.appconfiguration.ConfigurationClientBuilder;
import com.azure.spring.cloud.autoconfigure.AzureServiceConfigurationBase;
import com.azure.spring.cloud.autoconfigure.appconfiguration.properties.AzureAppConfigurationProperties;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.properties.AzureGlobalProperties;
import com.azure.spring.core.AzureSpringIdentifier;
import com.azure.spring.core.connectionstring.ConnectionStringProvider;
import com.azure.spring.core.connectionstring.StaticConnectionStringProvider;
import com.azure.spring.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.core.service.AzureServiceType;
import com.azure.spring.service.appconfiguration.AppConfigurationProperties;
import com.azure.spring.service.appconfiguration.ConfigurationClientBuilderFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={ConfigurationClientBuilder.class})
@ConditionalOnProperty(value={"spring.cloud.azure.appconfiguration.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.appconfiguration", name={"endpoint", "connection-string"})
public class AzureAppConfigurationAutoConfiguration
extends AzureServiceConfigurationBase {
    public AzureAppConfigurationAutoConfiguration(AzureGlobalProperties azureGlobalProperties) {
        super(azureGlobalProperties);
    }

    @ConfigurationProperties(prefix="spring.cloud.azure.appconfiguration")
    @Bean
    public AzureAppConfigurationProperties azureAppConfigurationProperties() {
        return this.loadProperties(this.azureGlobalProperties, new AzureAppConfigurationProperties());
    }

    @Bean
    @ConditionalOnMissingBean
    public ConfigurationClient azureConfigurationClient(ConfigurationClientBuilder builder) {
        return builder.buildClient();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConfigurationAsyncClient azureConfigurationAsyncClient(ConfigurationClientBuilder builder) {
        return builder.buildAsyncClient();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConfigurationClientBuilder configurationClientBuilder(ConfigurationClientBuilderFactory factory) {
        return (ConfigurationClientBuilder)factory.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConfigurationClientBuilderFactory configurationClientBuilderFactory(AzureAppConfigurationProperties properties, ObjectProvider<ConnectionStringProvider<AzureServiceType.AppConfiguration>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<ConfigurationClientBuilder>> customizers) {
        ConfigurationClientBuilderFactory factory = new ConfigurationClientBuilderFactory((AppConfigurationProperties)properties);
        factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_APP_CONFIG);
        connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((ConfigurationClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
        customizers.orderedStream().forEach(arg_0 -> ((ConfigurationClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.azure.appconfiguration.connection-string"})
    public StaticConnectionStringProvider<AzureServiceType.AppConfiguration> staticAppConfigurationConnectionStringProvider(AzureAppConfigurationProperties properties) {
        return new StaticConnectionStringProvider((Object)AzureServiceType.APP_CONFIGURATION, properties.getConnectionString());
    }
}

