/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.context;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.spring.cloud.autoconfigure.properties.AzureGlobalProperties;
import com.azure.spring.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.core.factory.AbstractAzureServiceClientBuilderFactory;
import com.azure.spring.core.factory.credential.AbstractAzureCredentialBuilderFactory;
import com.azure.spring.core.factory.credential.DefaultAzureCredentialBuilderFactory;
import com.azure.spring.core.properties.AzureProperties;
import java.util.concurrent.ExecutorService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration(proxyBeanMethods=false)
public class AzureDefaultTokenCredentialAutoConfiguration {
    private final AzureGlobalProperties azureGlobalProperties;

    public AzureDefaultTokenCredentialAutoConfiguration(AzureGlobalProperties azureGlobalProperties) {
        this.azureGlobalProperties = azureGlobalProperties;
    }

    @ConditionalOnMissingBean(name={"springDefaultAzureCredential"})
    @Bean(name={"springDefaultAzureCredential"})
    @Order
    public TokenCredential tokenCredential(AbstractAzureCredentialBuilderFactory<DefaultAzureCredentialBuilder> factory) {
        return ((DefaultAzureCredentialBuilder)factory.build()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public AbstractAzureCredentialBuilderFactory<DefaultAzureCredentialBuilder> azureCredentialBuilderFactory(ObjectProvider<AzureServiceClientBuilderCustomizer<DefaultAzureCredentialBuilder>> customizers, ObjectProvider<ThreadPoolTaskExecutor> threadPoolTaskExecutors) {
        DefaultAzureCredentialBuilderFactory factory = new DefaultAzureCredentialBuilderFactory((AzureProperties)this.azureGlobalProperties);
        threadPoolTaskExecutors.ifAvailable(tpe -> factory.setExecutorService((ExecutorService)tpe.getThreadPoolExecutor()));
        customizers.orderedStream().forEach(arg_0 -> ((DefaultAzureCredentialBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }

    @Bean
    public AzureServiceClientBuilderFactoryPostProcessor builderFactoryBeanPostProcessor() {
        return new AzureServiceClientBuilderFactoryPostProcessor();
    }

    static class AzureServiceClientBuilderFactoryPostProcessor
    implements BeanPostProcessor,
    BeanFactoryAware {
        private BeanFactory beanFactory;

        AzureServiceClientBuilderFactoryPostProcessor() {
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof AbstractAzureCredentialBuilderFactory) {
                return bean;
            }
            if (bean instanceof AbstractAzureServiceClientBuilderFactory && this.beanFactory.containsBean("springDefaultAzureCredential")) {
                ((AbstractAzureServiceClientBuilderFactory)bean).setDefaultTokenCredential((TokenCredential)this.beanFactory.getBean("springDefaultAzureCredential"));
            }
            return bean;
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }
    }
}

