/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.cosmos;

import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.CosmosClient;
import com.azure.cosmos.CosmosClientBuilder;
import com.azure.spring.cloud.autoconfigure.AzureServiceConfigurationBase;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.cosmos.properties.AzureCosmosProperties;
import com.azure.spring.cloud.autoconfigure.properties.AzureGlobalProperties;
import com.azure.spring.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.service.cosmos.CosmosClientBuilderFactory;
import com.azure.spring.service.cosmos.CosmosProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={CosmosClientBuilder.class})
@ConditionalOnProperty(value={"spring.cloud.azure.cosmos.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.cosmos", name={"endpoint"})
public class AzureCosmosAutoConfiguration
extends AzureServiceConfigurationBase {
    public AzureCosmosAutoConfiguration(AzureGlobalProperties azureGlobalProperties) {
        super(azureGlobalProperties);
    }

    @Bean
    @ConfigurationProperties(value="spring.cloud.azure.cosmos")
    public AzureCosmosProperties azureCosmosProperties() {
        return this.loadProperties(this.azureGlobalProperties, new AzureCosmosProperties());
    }

    @Bean
    @ConditionalOnMissingBean
    public CosmosClient azureCosmosClient(CosmosClientBuilder builder) {
        return builder.buildClient();
    }

    @Bean
    @ConditionalOnMissingBean
    public CosmosAsyncClient azureCosmosAsyncClient(CosmosClientBuilder builder) {
        return builder.buildAsyncClient();
    }

    @Bean
    @ConditionalOnMissingBean
    public CosmosClientBuilder cosmosClientBuilder(CosmosClientBuilderFactory factory) {
        return (CosmosClientBuilder)factory.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public CosmosClientBuilderFactory cosmosClientBuilderFactory(AzureCosmosProperties properties, ObjectProvider<AzureServiceClientBuilderCustomizer<CosmosClientBuilder>> customizers) {
        CosmosClientBuilderFactory factory = new CosmosClientBuilderFactory((CosmosProperties)properties);
        customizers.orderedStream().forEach(arg_0 -> ((CosmosClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }
}

