/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.eventhubs;

import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.eventhubs.properties.AzureEventHubsProperties;
import com.azure.spring.core.AzureSpringIdentifier;
import com.azure.spring.core.connectionstring.ConnectionStringProvider;
import com.azure.spring.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.core.service.AzureServiceType;
import com.azure.spring.service.eventhubs.factory.EventHubClientBuilderFactory;
import com.azure.spring.service.eventhubs.properties.EventHubsCommonDescriptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.eventhubs", name={"connection-string", "namespace"})
@ConditionalOnProperty(prefix="spring.cloud.azure.eventhubs", name={"event-hub-name"})
class AzureEventHubsClientBuilderConfiguration {
    AzureEventHubsClientBuilderConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    public EventHubClientBuilder eventHubClientBuilder(EventHubClientBuilderFactory factory) {
        return (EventHubClientBuilder)factory.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public EventHubClientBuilderFactory eventHubClientBuilderFactory(AzureEventHubsProperties properties, ObjectProvider<ConnectionStringProvider<AzureServiceType.EventHubs>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<EventHubClientBuilder>> customizers) {
        EventHubClientBuilderFactory factory = new EventHubClientBuilderFactory((EventHubsCommonDescriptor)properties);
        factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_EVENT_HUBS);
        connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((EventHubClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
        customizers.orderedStream().forEach(arg_0 -> ((EventHubClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }
}

