/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.eventhubs;

import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.eventhubs.AzureEventHubsAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.eventhubs.properties.AzureEventHubsProperties;
import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.core.properties.util.AzurePropertiesUtils;
import com.azure.spring.eventhubs.core.EventHubsProcessorContainer;
import com.azure.spring.eventhubs.core.EventHubsTemplate;
import com.azure.spring.eventhubs.core.processor.DefaultEventHubsNamespaceProcessorFactory;
import com.azure.spring.eventhubs.core.processor.EventHubsProcessorFactory;
import com.azure.spring.eventhubs.core.producer.DefaultEventHubsNamespaceProducerFactory;
import com.azure.spring.eventhubs.core.producer.EventHubsProducerFactory;
import com.azure.spring.eventhubs.core.properties.NamespaceProperties;
import com.azure.spring.eventhubs.core.properties.ProcessorProperties;
import com.azure.spring.eventhubs.core.properties.ProducerProperties;
import com.azure.spring.messaging.PropertiesSupplier;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import reactor.util.function.Tuple2;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={EventHubsTemplate.class})
@AutoConfigureAfter(value={AzureEventHubsAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.azure.eventhubs.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.eventhubs", name={"connection-string", "namespace"})
@ConditionalOnBean(value={AzureEventHubsProperties.class})
@Import(value={EventHubsTemplateConfiguration.class, ProcessorContainerConfiguration.class})
public class AzureEventHubsMessagingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public NamespaceProperties eventHubNamespaceProperties(AzureEventHubsProperties properties) {
        NamespaceProperties namespaceProperties = new NamespaceProperties();
        AzurePropertiesUtils.copyAzureCommonProperties((AzureProperties)properties, (AzureProperties)namespaceProperties);
        BeanUtils.copyProperties((Object)properties, (Object)namespaceProperties);
        AzurePropertiesUtils.copyAzureCommonProperties((AzureProperties)properties, (AzureProperties)namespaceProperties);
        return namespaceProperties;
    }

    @Configuration(proxyBeanMethods=false)
    public static class EventHubsTemplateConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public EventHubsProducerFactory defaultEventHubsNamespaceProducerFactory(NamespaceProperties properties, ObjectProvider<PropertiesSupplier<String, ProducerProperties>> suppliers) {
            return new DefaultEventHubsNamespaceProducerFactory(properties, (PropertiesSupplier)suppliers.getIfAvailable());
        }

        @Bean
        @ConditionalOnMissingBean
        public EventHubsTemplate eventHubsTemplate(EventHubsProducerFactory producerFactory) {
            return new EventHubsTemplate(producerFactory);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={CheckpointStore.class})
    public static class ProcessorContainerConfiguration {
        @Bean
        @ConditionalOnMissingBean
        public EventHubsProcessorFactory defaultEventHubsNamespaceProcessorFactory(NamespaceProperties properties, CheckpointStore checkpointStore, ObjectProvider<PropertiesSupplier<Tuple2<String, String>, ProcessorProperties>> suppliers) {
            return new DefaultEventHubsNamespaceProcessorFactory(checkpointStore, properties, (PropertiesSupplier)suppliers.getIfAvailable());
        }

        @Bean
        @ConditionalOnMissingBean
        public EventHubsProcessorContainer eventHubsProcessorContainer(EventHubsProcessorFactory processorFactory) {
            return new EventHubsProcessorContainer(processorFactory);
        }
    }
}

