/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.eventhubs;

import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventProcessorClient;
import com.azure.messaging.eventhubs.EventProcessorClientBuilder;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.eventhubs.properties.AzureEventHubsProperties;
import com.azure.spring.core.AzureSpringIdentifier;
import com.azure.spring.core.connectionstring.ConnectionStringProvider;
import com.azure.spring.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.core.service.AzureServiceType;
import com.azure.spring.service.eventhubs.factory.EventProcessorClientBuilderFactory;
import com.azure.spring.service.eventhubs.processor.EventProcessingListener;
import com.azure.spring.service.eventhubs.properties.EventHubsProcessorDescriptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={EventProcessorClientBuilder.class})
@ConditionalOnBean(value={EventProcessingListener.class, CheckpointStore.class})
@Conditional(value={ProcessorAvailableCondition.class})
class AzureEventHubsProcessorClientConfiguration {
    private final AzureEventHubsProperties.Processor processorProperties;

    AzureEventHubsProcessorClientConfiguration(AzureEventHubsProperties eventHubsProperties) {
        this.processorProperties = eventHubsProperties.buildProcessorProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public EventProcessorClient eventProcessorClient(EventProcessorClientBuilder builder) {
        return builder.buildEventProcessorClient();
    }

    @Bean
    @ConditionalOnMissingBean
    public EventProcessorClientBuilderFactory eventProcessorClientBuilderFactory(CheckpointStore checkpointStore, EventProcessingListener listener, ObjectProvider<ConnectionStringProvider<AzureServiceType.EventHubs>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<EventProcessorClientBuilder>> customizers) {
        EventProcessorClientBuilderFactory factory = new EventProcessorClientBuilderFactory((EventHubsProcessorDescriptor)this.processorProperties, checkpointStore, listener);
        factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_EVENT_HUBS);
        connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((EventProcessorClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
        customizers.orderedStream().forEach(arg_0 -> ((EventProcessorClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    public EventProcessorClientBuilder eventProcessorClientBuilder(EventProcessorClientBuilderFactory factory) {
        return (EventProcessorClientBuilder)factory.build();
    }

    static class ProcessorAvailableCondition
    extends AllNestedConditions {
        ProcessorAvailableCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnAnyProperty(prefix="spring.cloud.azure.eventhubs", name={"namespace", "connection-string", "processor.namespace", "processor.connection-string"})
        static class ConnectionInfo {
            ConnectionInfo() {
            }
        }

        @ConditionalOnProperty(prefix="spring.cloud.azure.eventhubs.processor", name={"consumer-group"})
        static class ConsumerGroup {
            ConsumerGroup() {
            }
        }

        @ConditionalOnAnyProperty(prefix="spring.cloud.azure.eventhubs", name={"event-hub-name", "processor.event-hub-name"})
        static class EventHubName {
            EventHubName() {
            }
        }
    }
}

