/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.eventhubs;

import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.messaging.eventhubs.EventHubProducerClient;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnMissingProperty;
import com.azure.spring.cloud.autoconfigure.eventhubs.properties.AzureEventHubsProperties;
import com.azure.spring.core.AzureSpringIdentifier;
import com.azure.spring.core.connectionstring.ConnectionStringProvider;
import com.azure.spring.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.core.service.AzureServiceType;
import com.azure.spring.service.eventhubs.factory.EventHubClientBuilderFactory;
import com.azure.spring.service.eventhubs.properties.EventHubsCommonDescriptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.eventhubs", name={"event-hub-name", "producer.event-hub-name"})
class AzureEventHubsProducerClientConfiguration {
    AzureEventHubsProducerClientConfiguration() {
    }

    @ConditionalOnAnyProperty(prefix="spring.cloud.azure.eventhubs.producer", name={"connection-string", "namespace"})
    @Configuration(proxyBeanMethods=false)
    static class DedicatedProducerConnectionConfiguration {
        private final AzureEventHubsProperties.Producer producerProperties;

        DedicatedProducerConnectionConfiguration(AzureEventHubsProperties eventHubsProperties) {
            this.producerProperties = eventHubsProperties.buildProducerProperties();
        }

        @Bean(value={"EVENT_HUB_PRODUCER_CLIENT_BUILDER_FACTORY_BEAN_NAME"})
        @ConditionalOnMissingBean(name={"EVENT_HUB_PRODUCER_CLIENT_BUILDER_FACTORY_BEAN_NAME"})
        public EventHubClientBuilderFactory eventHubClientBuilderFactoryForProducer(ObjectProvider<ConnectionStringProvider<AzureServiceType.EventHubs>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<EventHubClientBuilder>> customizers) {
            EventHubClientBuilderFactory factory = new EventHubClientBuilderFactory((EventHubsCommonDescriptor)this.producerProperties);
            factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_EVENT_HUBS);
            connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((EventHubClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
            customizers.orderedStream().forEach(arg_0 -> ((EventHubClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
            return factory;
        }

        @Bean(value={"EVENT_HUB_PRODUCER_CLIENT_BUILDER_BEAN_NAME"})
        @ConditionalOnBean(name={"EVENT_HUB_PRODUCER_CLIENT_BUILDER_FACTORY_BEAN_NAME"})
        @ConditionalOnMissingBean(name={"EVENT_HUB_PRODUCER_CLIENT_BUILDER_BEAN_NAME"})
        public EventHubClientBuilder eventHubClientBuilderForProducer(@Qualifier(value="EVENT_HUB_PRODUCER_CLIENT_BUILDER_FACTORY_BEAN_NAME") EventHubClientBuilderFactory clientBuilderFactory) {
            return (EventHubClientBuilder)clientBuilderFactory.build();
        }

        @Bean
        @ConditionalOnMissingBean
        public EventHubProducerAsyncClient eventHubProducerAsyncClient(@Qualifier(value="EVENT_HUB_PRODUCER_CLIENT_BUILDER_BEAN_NAME") EventHubClientBuilder builder) {
            return builder.buildAsyncProducerClient();
        }

        @Bean
        @ConditionalOnMissingBean
        public EventHubProducerClient eventHubProducerClient(@Qualifier(value="EVENT_HUB_PRODUCER_CLIENT_BUILDER_BEAN_NAME") EventHubClientBuilder builder) {
            return builder.buildProducerClient();
        }
    }

    @ConditionalOnMissingProperty(prefix="spring.cloud.azure.eventhubs.producer", name={"connection-string", "namespace"})
    @ConditionalOnAnyProperty(prefix="spring.cloud.azure.eventhubs", name={"connection-string", "namespace"})
    @ConditionalOnBean(value={EventHubClientBuilder.class})
    @Configuration(proxyBeanMethods=false)
    static class SharedProducerConnectionConfiguration {
        SharedProducerConnectionConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public EventHubProducerAsyncClient eventHubProducerAsyncClient(EventHubClientBuilder builder) {
            return builder.buildAsyncProducerClient();
        }

        @Bean
        @ConditionalOnMissingBean
        public EventHubProducerClient eventHubProducerClient(EventHubClientBuilder builder) {
            return builder.buildProducerClient();
        }
    }
}

