/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.eventhubs.properties;

import com.azure.spring.cloud.autoconfigure.eventhubs.properties.AzureEventHubsCommonProperties;
import com.azure.spring.cloud.autoconfigure.storage.blob.properties.AzureStorageBlobProperties;
import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.core.properties.util.AzurePropertiesUtils;
import com.azure.spring.service.eventhubs.properties.EventHubsConsumerDescriptor;
import com.azure.spring.service.eventhubs.properties.EventHubsNamespaceDescriptor;
import com.azure.spring.service.eventhubs.properties.EventHubsProcessorDescriptor;
import com.azure.spring.service.eventhubs.properties.EventHubsProducerDescriptor;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.PropertyMapper;

public class AzureEventHubsProperties
extends AzureEventHubsCommonProperties
implements EventHubsNamespaceDescriptor {
    public static final String PREFIX = "spring.cloud.azure.eventhubs";
    private Boolean isSharedConnection;
    private final Producer producer = new Producer();
    private final Consumer consumer = new Consumer();
    private final Processor processor = new Processor();

    public Producer buildProducerProperties() {
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        Producer properties = new Producer();
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)this, (AzureProperties)this.producer, (AzureProperties)properties);
        propertyMapper.from((Object)this.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.getEventHubName()).to(properties::setEventHubName);
        propertyMapper.from((Object)this.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.getCustomEndpointAddress()).to(properties::setCustomEndpointAddress);
        propertyMapper.from((Object)this.producer.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.producer.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.producer.getEventHubName()).to(properties::setEventHubName);
        propertyMapper.from((Object)this.producer.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.producer.getCustomEndpointAddress()).to(properties::setCustomEndpointAddress);
        return properties;
    }

    public Consumer buildConsumerProperties() {
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        Consumer properties = new Consumer();
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)this, (AzureProperties)this.consumer, (AzureProperties)properties);
        propertyMapper.from((Object)this.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.getEventHubName()).to(properties::setEventHubName);
        propertyMapper.from((Object)this.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.getCustomEndpointAddress()).to(properties::setCustomEndpointAddress);
        propertyMapper.from((Object)this.consumer.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.consumer.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.consumer.getEventHubName()).to(properties::setEventHubName);
        propertyMapper.from((Object)this.consumer.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.consumer.getCustomEndpointAddress()).to(properties::setCustomEndpointAddress);
        propertyMapper.from((Object)this.consumer.getPrefetchCount()).to(properties::setPrefetchCount);
        propertyMapper.from((Object)this.consumer.getConsumerGroup()).to(properties::setConsumerGroup);
        return properties;
    }

    public Processor buildProcessorProperties() {
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        Processor properties = new Processor();
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)this, (AzureProperties)this.processor, (AzureProperties)properties);
        propertyMapper.from((Object)this.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.getEventHubName()).to(properties::setEventHubName);
        propertyMapper.from((Object)this.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.getCustomEndpointAddress()).to(properties::setCustomEndpointAddress);
        propertyMapper.from((Object)this.processor.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.processor.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.processor.getEventHubName()).to(properties::setEventHubName);
        propertyMapper.from((Object)this.processor.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.processor.getCustomEndpointAddress()).to(properties::setCustomEndpointAddress);
        propertyMapper.from((Object)this.processor.getPrefetchCount()).to(properties::setPrefetchCount);
        propertyMapper.from((Object)this.processor.getConsumerGroup()).to(properties::setConsumerGroup);
        propertyMapper.from((Object)this.processor.trackLastEnqueuedEventProperties).to(properties::setTrackLastEnqueuedEventProperties);
        propertyMapper.from((Object)this.processor.initialPartitionEventPosition).to(properties::setInitialPartitionEventPosition);
        propertyMapper.from((Object)this.processor.partitionOwnershipExpirationInterval).to(properties::setPartitionOwnershipExpirationInterval);
        propertyMapper.from((Object)this.processor.batch.getMaxSize()).to(arg_0 -> ((Processor.Batch)properties.batch).setMaxSize(arg_0));
        propertyMapper.from((Object)this.processor.batch.getMaxWaitTime()).to(arg_0 -> ((Processor.Batch)properties.batch).setMaxWaitTime(arg_0));
        propertyMapper.from((Object)this.processor.loadBalancing.getStrategy()).to(arg_0 -> ((Processor.LoadBalancing)properties.loadBalancing).setStrategy(arg_0));
        propertyMapper.from((Object)this.processor.loadBalancing.getUpdateInterval()).to(arg_0 -> ((Processor.LoadBalancing)properties.loadBalancing).setUpdateInterval(arg_0));
        AzurePropertiesUtils.copyAzureCommonProperties((AzureProperties)this.processor.checkpointStore, (AzureProperties)properties.checkpointStore);
        BeanUtils.copyProperties((Object)this.processor.checkpointStore, (Object)properties.checkpointStore);
        return properties;
    }

    public Boolean getSharedConnection() {
        return this.isSharedConnection;
    }

    public void setSharedConnection(Boolean sharedConnection) {
        this.isSharedConnection = sharedConnection;
    }

    public Producer getProducer() {
        return this.producer;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public static class Processor
    extends Consumer
    implements EventHubsProcessorDescriptor {
        private Boolean trackLastEnqueuedEventProperties;
        private Map<String, EventHubsProcessorDescriptor.StartPosition> initialPartitionEventPosition = new HashMap<String, EventHubsProcessorDescriptor.StartPosition>();
        private Duration partitionOwnershipExpirationInterval;
        private final Batch batch = new Batch();
        private final LoadBalancing loadBalancing = new LoadBalancing();
        private final BlobCheckpointStore checkpointStore = new BlobCheckpointStore();

        public Boolean getTrackLastEnqueuedEventProperties() {
            return this.trackLastEnqueuedEventProperties;
        }

        public void setTrackLastEnqueuedEventProperties(Boolean trackLastEnqueuedEventProperties) {
            this.trackLastEnqueuedEventProperties = trackLastEnqueuedEventProperties;
        }

        public Map<String, EventHubsProcessorDescriptor.StartPosition> getInitialPartitionEventPosition() {
            return this.initialPartitionEventPosition;
        }

        public void setInitialPartitionEventPosition(Map<String, EventHubsProcessorDescriptor.StartPosition> initialPartitionEventPosition) {
            this.initialPartitionEventPosition = initialPartitionEventPosition;
        }

        public Duration getPartitionOwnershipExpirationInterval() {
            return this.partitionOwnershipExpirationInterval;
        }

        public void setPartitionOwnershipExpirationInterval(Duration partitionOwnershipExpirationInterval) {
            this.partitionOwnershipExpirationInterval = partitionOwnershipExpirationInterval;
        }

        public Batch getBatch() {
            return this.batch;
        }

        public LoadBalancing getLoadBalancing() {
            return this.loadBalancing;
        }

        public BlobCheckpointStore getCheckpointStore() {
            return this.checkpointStore;
        }

        public static class BlobCheckpointStore
        extends AzureStorageBlobProperties {
            private Boolean createContainerIfNotExists;

            public Boolean getCreateContainerIfNotExists() {
                return this.createContainerIfNotExists;
            }

            public void setCreateContainerIfNotExists(Boolean createContainerIfNotExists) {
                this.createContainerIfNotExists = createContainerIfNotExists;
            }
        }

        public static class Batch
        extends EventHubsProcessorDescriptor.Batch {
        }

        public static class LoadBalancing
        extends EventHubsProcessorDescriptor.LoadBalancing {
        }
    }

    public static class Consumer
    extends AzureEventHubsCommonProperties
    implements EventHubsConsumerDescriptor {
        protected String consumerGroup;
        protected Integer prefetchCount;

        public String getConsumerGroup() {
            return this.consumerGroup;
        }

        public void setConsumerGroup(String consumerGroup) {
            this.consumerGroup = consumerGroup;
        }

        public Integer getPrefetchCount() {
            return this.prefetchCount;
        }

        public void setPrefetchCount(Integer prefetchCount) {
            this.prefetchCount = prefetchCount;
        }
    }

    public static class Producer
    extends AzureEventHubsCommonProperties
    implements EventHubsProducerDescriptor {
    }
}

