/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.jms;

import com.azure.spring.cloud.autoconfigure.jms.AbstractServiceBusJmsAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.jms.SpringServiceBusJmsConnectionFactory;
import com.azure.spring.cloud.autoconfigure.jms.properties.AzureServiceBusJmsProperties;
import com.azure.spring.core.AzureSpringIdentifier;
import com.microsoft.azure.servicebus.jms.ServiceBusJmsConnectionFactory;
import com.microsoft.azure.servicebus.jms.ServiceBusJmsConnectionFactorySettings;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ServiceBusJmsConnectionFactory.class})
@ConditionalOnProperty(value={"spring.jms.servicebus.enabled"}, matchIfMissing=true)
@ConditionalOnExpression(value="'${spring.jms.servicebus.pricing-tier}'.equalsIgnoreCase('premium')")
@EnableConfigurationProperties(value={AzureServiceBusJmsProperties.class})
public class PremiumServiceBusJmsAutoConfiguration
extends AbstractServiceBusJmsAutoConfiguration {
    public PremiumServiceBusJmsAutoConfiguration(AzureServiceBusJmsProperties azureServiceBusJMSProperties) {
        super(azureServiceBusJMSProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectionFactory jmsConnectionFactory(AzureServiceBusJmsProperties serviceBusJMSProperties) {
        String connectionString = serviceBusJMSProperties.getConnectionString();
        String clientId = serviceBusJMSProperties.getTopicClientId();
        int idleTimeout = serviceBusJMSProperties.getIdleTimeout();
        ServiceBusJmsConnectionFactorySettings settings = new ServiceBusJmsConnectionFactorySettings(new LinkedHashMap());
        settings.setConnectionIdleTimeoutMS((long)idleTimeout);
        settings.setTraceFrames(false);
        settings.setShouldReconnect(false);
        this.configurePrefetch(serviceBusJMSProperties, settings.getConfigurationOptions());
        SpringServiceBusJmsConnectionFactory springServiceBusJmsConnectionFactory = new SpringServiceBusJmsConnectionFactory(connectionString, settings);
        springServiceBusJmsConnectionFactory.setClientId(clientId);
        springServiceBusJmsConnectionFactory.setCustomUserAgent(AzureSpringIdentifier.AZURE_SPRING_SERVICE_BUS + AzureSpringIdentifier.VERSION);
        return springServiceBusJmsConnectionFactory;
    }

    private void configurePrefetch(AzureServiceBusJmsProperties serviceBusJMSProperties, Map<String, String> configurationOptions) {
        AzureServiceBusJmsProperties.PrefetchPolicy prefetchPolicy = serviceBusJMSProperties.getPrefetchPolicy();
        int prefetchPolicyAll = prefetchPolicy.getAll();
        int durableTopicPrefetch = prefetchPolicy.getDurableTopicPrefetch();
        int queueBrowserPrefetch = prefetchPolicy.getQueueBrowserPrefetch();
        int queuePrefetch = prefetchPolicy.getQueuePrefetch();
        int topicPrefetch = prefetchPolicy.getTopicPrefetch();
        configurationOptions.put("jms.prefetchPolicy.all", String.valueOf(prefetchPolicyAll));
        configurationOptions.put("jms.prefetchPolicy.durableTopicPrefetch", String.valueOf(durableTopicPrefetch));
        configurationOptions.put("jms.prefetchPolicy.queueBrowserPrefetch", String.valueOf(queueBrowserPrefetch));
        configurationOptions.put("jms.prefetchPolicy.queuePrefetch", String.valueOf(queuePrefetch));
        configurationOptions.put("jms.prefetchPolicy.topicPrefetch", String.valueOf(topicPrefetch));
    }
}

