/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.keyvault.certificates;

import com.azure.security.keyvault.certificates.CertificateAsyncClient;
import com.azure.security.keyvault.certificates.CertificateClient;
import com.azure.security.keyvault.certificates.CertificateClientBuilder;
import com.azure.spring.cloud.autoconfigure.AzureServiceConfigurationBase;
import com.azure.spring.cloud.autoconfigure.keyvault.certificates.properties.AzureKeyVaultCertificateProperties;
import com.azure.spring.cloud.autoconfigure.properties.AzureGlobalProperties;
import com.azure.spring.core.AzureSpringIdentifier;
import com.azure.spring.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.service.keyvault.certificates.CertificateClientBuilderFactory;
import com.azure.spring.service.keyvault.certificates.KeyVaultCertificateProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={CertificateClientBuilder.class})
@ConditionalOnExpression(value="${spring.cloud.azure.keyvault.certificate.enabled:true}")
@ConditionalOnProperty(value={"spring.cloud.azure.keyvault.certificate.endpoint"})
public class AzureKeyVaultCertificateAutoConfiguration
extends AzureServiceConfigurationBase {
    public AzureKeyVaultCertificateAutoConfiguration(AzureGlobalProperties azureGlobalProperties) {
        super(azureGlobalProperties);
    }

    @ConfigurationProperties(prefix="spring.cloud.azure.keyvault.certificate")
    @Bean
    public AzureKeyVaultCertificateProperties azureKeyVaultCertificateProperties() {
        return this.loadProperties(this.azureGlobalProperties, new AzureKeyVaultCertificateProperties());
    }

    @Bean
    @ConditionalOnMissingBean
    public CertificateClient azureKeyVaultCertificateClient(CertificateClientBuilder builder) {
        return builder.buildClient();
    }

    @Bean
    @ConditionalOnMissingBean
    public CertificateAsyncClient azureKeyVaultCertificateAsyncClient(CertificateClientBuilder builder) {
        return builder.buildAsyncClient();
    }

    @Bean
    @ConditionalOnMissingBean
    public CertificateClientBuilder certificateClientBuilder(CertificateClientBuilderFactory factory) {
        return (CertificateClientBuilder)factory.build();
    }

    @Bean
    @ConditionalOnMissingBean
    public CertificateClientBuilderFactory certificateClientBuilderFactory(AzureKeyVaultCertificateProperties properties, ObjectProvider<AzureServiceClientBuilderCustomizer<CertificateClientBuilder>> customizers) {
        CertificateClientBuilderFactory factory = new CertificateClientBuilderFactory((KeyVaultCertificateProperties)properties);
        factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_KEY_VAULT);
        customizers.orderedStream().forEach(arg_0 -> ((CertificateClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }
}

