/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.keyvault.env;

import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.spring.cloud.autoconfigure.keyvault.env.KeyVaultOperation;
import com.azure.spring.cloud.autoconfigure.keyvault.env.KeyVaultPropertySource;
import com.azure.spring.cloud.autoconfigure.keyvault.secrets.AzureKeyVaultPropertySourceProperties;
import com.azure.spring.cloud.autoconfigure.keyvault.secrets.properties.AzureKeyVaultSecretProperties;
import com.azure.spring.cloud.autoconfigure.properties.AzureGlobalProperties;
import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.core.properties.util.AzurePropertiesUtils;
import com.azure.spring.service.keyvault.secrets.KeyVaultSecretProperties;
import com.azure.spring.service.keyvault.secrets.SecretClientBuilderFactory;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class KeyVaultEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    public static final int ORDER = -2147483637;
    private final Log logger;

    public KeyVaultEnvironmentPostProcessor(Log logger) {
        this.logger = logger;
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!this.isKeyVaultClientAvailable()) {
            this.logger.info((Object)"Key Vault client is not present, skip the Key Vault property source");
            return;
        }
        AzureKeyVaultSecretProperties keyVaultSecretProperties = this.loadProperties(Binder.get((Environment)environment));
        if (this.isKeyVaultPropertySourceEnabled(keyVaultSecretProperties)) {
            List<AzureKeyVaultPropertySourceProperties> propertySources = keyVaultSecretProperties.getPropertySources();
            Collections.reverse(propertySources);
            if (propertySources.isEmpty()) {
                propertySources.add(new AzureKeyVaultPropertySourceProperties());
            }
            for (AzureKeyVaultPropertySourceProperties propertySource : propertySources) {
                AzureKeyVaultPropertySourceProperties properties = this.getMergeProperties(keyVaultSecretProperties, propertySource);
                if (!properties.isEnabled()) continue;
                this.addKeyVaultPropertySource(environment, properties);
            }
        } else {
            this.logger.debug((Object)"Key Vault 'propertySourceEnabled' or 'enabled' is not enabled");
        }
    }

    private AzureKeyVaultPropertySourceProperties getMergeProperties(AzureKeyVaultSecretProperties secretProperties, AzureKeyVaultPropertySourceProperties propertySource) {
        AzureKeyVaultPropertySourceProperties mergedResult = new AzureKeyVaultPropertySourceProperties();
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)secretProperties, (AzureProperties)propertySource, (AzureProperties)mergedResult);
        mergedResult.setEndpoint(secretProperties.getEndpoint());
        mergedResult.setServiceVersion(secretProperties.getServiceVersion());
        mergedResult.setEnabled(propertySource.isEnabled());
        mergedResult.setName(propertySource.getName());
        mergedResult.setCaseSensitive(propertySource.getCaseSensitive());
        mergedResult.setSecretKeys(propertySource.getSecretKeys());
        mergedResult.setRefreshInterval(propertySource.getRefreshInterval());
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        propertyMapper.from((Object)propertySource.getEndpoint()).to(mergedResult::setEndpoint);
        propertyMapper.from((Object)propertySource.getServiceVersion()).to(mergedResult::setServiceVersion);
        return mergedResult;
    }

    public void addKeyVaultPropertySource(ConfigurableEnvironment environment, AzureKeyVaultPropertySourceProperties propertySource) {
        Assert.notNull((Object)propertySource.getEndpoint(), (String)"endpoint must not be null!");
        AzureKeyVaultSecretProperties secretProperties = new AzureKeyVaultSecretProperties();
        AzurePropertiesUtils.copyAzureCommonProperties((AzureProperties)propertySource, (AzureProperties)secretProperties);
        secretProperties.setServiceVersion(propertySource.getServiceVersion());
        secretProperties.setEndpoint(propertySource.getEndpoint());
        SecretClient secretClient = ((SecretClientBuilder)new SecretClientBuilderFactory((KeyVaultSecretProperties)secretProperties).build()).buildClient();
        try {
            MutablePropertySources sources = environment.getPropertySources();
            boolean caseSensitive = Boolean.TRUE.equals(propertySource.getCaseSensitive());
            KeyVaultOperation keyVaultOperation = new KeyVaultOperation(secretClient, propertySource.getRefreshInterval(), propertySource.getSecretKeys(), caseSensitive);
            KeyVaultPropertySource keyVaultPropertySource = new KeyVaultPropertySource(propertySource.getName(), keyVaultOperation);
            if (sources.contains("systemEnvironment")) {
                sources.addAfter("systemEnvironment", (PropertySource)keyVaultPropertySource);
            } else {
                sources.addFirst((PropertySource)keyVaultPropertySource);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to configure KeyVault property source", ex);
        }
    }

    private AzureKeyVaultSecretProperties loadProperties(Binder binder) {
        AzureGlobalProperties azureProperties = (AzureGlobalProperties)binder.bind("spring.cloud.azure", Bindable.of(AzureGlobalProperties.class)).orElseGet(AzureGlobalProperties::new);
        AzureKeyVaultSecretProperties existingValue = new AzureKeyVaultSecretProperties();
        AzurePropertiesUtils.copyAzureCommonProperties((AzureProperties)azureProperties, (AzureProperties)existingValue);
        return (AzureKeyVaultSecretProperties)binder.bind("spring.cloud.azure.keyvault.secret", Bindable.of(AzureKeyVaultSecretProperties.class).withExistingValue((Object)existingValue)).orElseGet(AzureKeyVaultSecretProperties::new);
    }

    private boolean isKeyVaultPropertySourceEnabled(AzureKeyVaultSecretProperties properties) {
        return (Boolean.TRUE.equals(properties.getPropertySourceEnabled()) || !properties.getPropertySources().isEmpty()) && Boolean.TRUE.equals(properties.isEnabled());
    }

    private boolean isKeyVaultClientAvailable() {
        return ClassUtils.isPresent((String)"com.azure.security.keyvault.secrets.SecretClient", (ClassLoader)KeyVaultEnvironmentPostProcessor.class.getClassLoader());
    }

    public int getOrder() {
        return -2147483637;
    }
}

