/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.properties;

import com.azure.core.amqp.AmqpTransportType;
import com.azure.spring.cloud.autoconfigure.properties.core.authentication.TokenCredentialCP;
import com.azure.spring.cloud.autoconfigure.properties.core.client.ClientCP;
import com.azure.spring.cloud.autoconfigure.properties.core.client.HttpLoggingCP;
import com.azure.spring.cloud.autoconfigure.properties.core.profile.AzureProfileCP;
import com.azure.spring.cloud.autoconfigure.properties.core.proxy.ProxyCP;
import com.azure.spring.cloud.autoconfigure.properties.core.retry.RetryCP;
import com.azure.spring.core.properties.AzureProperties;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="spring.cloud.azure")
public class AzureGlobalProperties
implements AzureProperties {
    public static final String PREFIX = "spring.cloud.azure";
    @NestedConfigurationProperty
    private final GlobalClientCP client = new GlobalClientCP();
    @NestedConfigurationProperty
    private final GlobalProxyCP proxy = new GlobalProxyCP();
    @NestedConfigurationProperty
    private final GlobalRetryCP retry = new GlobalRetryCP();
    @NestedConfigurationProperty
    private final TokenCredentialCP credential = new TokenCredentialCP();
    @NestedConfigurationProperty
    private final AzureProfileCP profile = new AzureProfileCP();

    public GlobalClientCP getClient() {
        return this.client;
    }

    public GlobalProxyCP getProxy() {
        return this.proxy;
    }

    public GlobalRetryCP getRetry() {
        return this.retry;
    }

    public TokenCredentialCP getCredential() {
        return this.credential;
    }

    public AzureProfileCP getProfile() {
        return this.profile;
    }

    public static final class AmqpClientCP {
        private AmqpTransportType transportType = AmqpTransportType.AMQP;

        public AmqpTransportType getTransportType() {
            return this.transportType;
        }

        public void setTransportType(AmqpTransportType transportType) {
            this.transportType = transportType;
        }
    }

    public static final class HttpClientCP {
        private Duration writeTimeout;
        private Duration responseTimeout;
        private Duration readTimeout;
        private Duration connectTimeout;
        private Integer maximumConnectionPoolSize;
        private Duration connectionIdleTimeout;
        @NestedConfigurationProperty
        private final HttpLoggingCP logging = new HttpLoggingCP();

        public Duration getWriteTimeout() {
            return this.writeTimeout;
        }

        public void setWriteTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
        }

        public Duration getResponseTimeout() {
            return this.responseTimeout;
        }

        public void setResponseTimeout(Duration responseTimeout) {
            this.responseTimeout = responseTimeout;
        }

        public Duration getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
        }

        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public Integer getMaximumConnectionPoolSize() {
            return this.maximumConnectionPoolSize;
        }

        public void setMaximumConnectionPoolSize(Integer maximumConnectionPoolSize) {
            this.maximumConnectionPoolSize = maximumConnectionPoolSize;
        }

        public Duration getConnectionIdleTimeout() {
            return this.connectionIdleTimeout;
        }

        public void setConnectionIdleTimeout(Duration connectionIdleTimeout) {
            this.connectionIdleTimeout = connectionIdleTimeout;
        }

        public HttpLoggingCP getLogging() {
            return this.logging;
        }
    }

    public static final class HttpProxyCP {
        private String nonProxyHosts;

        public String getNonProxyHosts() {
            return this.nonProxyHosts;
        }

        public void setNonProxyHosts(String nonProxyHosts) {
            this.nonProxyHosts = nonProxyHosts;
        }
    }

    public static final class HttpRetryCP {
        private String retryAfterHeader;
        private ChronoUnit retryAfterTimeUnit;

        public String getRetryAfterHeader() {
            return this.retryAfterHeader;
        }

        public void setRetryAfterHeader(String retryAfterHeader) {
            this.retryAfterHeader = retryAfterHeader;
        }

        public ChronoUnit getRetryAfterTimeUnit() {
            return this.retryAfterTimeUnit;
        }

        public void setRetryAfterTimeUnit(ChronoUnit retryAfterTimeUnit) {
            this.retryAfterTimeUnit = retryAfterTimeUnit;
        }
    }

    public static final class GlobalRetryCP
    extends RetryCP {
        private final HttpRetryCP http = new HttpRetryCP();

        public HttpRetryCP getHttp() {
            return this.http;
        }
    }

    public static final class GlobalProxyCP
    extends ProxyCP {
        private final HttpProxyCP http = new HttpProxyCP();

        public HttpProxyCP getHttp() {
            return this.http;
        }
    }

    public static final class GlobalClientCP
    extends ClientCP {
        private final HttpClientCP http = new HttpClientCP();
        private final AmqpClientCP amqp = new AmqpClientCP();

        public HttpClientCP getHttp() {
            return this.http;
        }

        public AmqpClientCP getAmqp() {
            return this.amqp;
        }
    }
}

