/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.redis;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.redis.models.RedisCache;
import com.azure.spring.cloud.autoconfigure.redis.AzureRedisProperties;
import com.azure.spring.cloud.autoconfigure.resourcemanager.AzureResourceManagerAutoConfiguration;
import java.util.Arrays;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.core.RedisOperations;

@Configuration
@AutoConfigureAfter(value={AzureResourceManagerAutoConfiguration.class})
@ConditionalOnExpression(value="${spring.cloud.azure.redis.enabled:true}")
@ConditionalOnProperty(value={"spring.cloud.azure.redis.name", "spring.cloud.azure.redis.resource.resource-group"})
@ConditionalOnClass(value={RedisOperations.class, AzureResourceManager.class})
@ConditionalOnBean(value={AzureResourceManager.class})
@EnableConfigurationProperties(value={AzureRedisProperties.class})
public class AzureRedisAutoConfiguration {
    @Primary
    @Bean
    public RedisProperties redisProperties(AzureRedisProperties azureRedisProperties, AzureResourceManager azureResourceManager) {
        boolean isCluster;
        String cacheName = azureRedisProperties.getName();
        String resourceGroup = azureRedisProperties.getResource().getResourceGroup();
        RedisCache redisCache = (RedisCache)azureResourceManager.redisCaches().getByResourceGroup(resourceGroup, cacheName);
        RedisProperties redisProperties = new RedisProperties();
        boolean useSsl = !redisCache.nonSslPort();
        int port = useSsl ? redisCache.sslPort() : redisCache.port();
        boolean bl = isCluster = redisCache.shardCount() > 0;
        if (isCluster) {
            RedisProperties.Cluster cluster = new RedisProperties.Cluster();
            cluster.setNodes(Arrays.asList(redisCache.hostname() + ":" + port));
            redisProperties.setCluster(cluster);
        } else {
            redisProperties.setHost(redisCache.hostname());
            redisProperties.setPort(port);
        }
        redisProperties.setPassword(redisCache.keys().primaryKey());
        redisProperties.setSsl(useSsl);
        return redisProperties;
    }
}

