/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.resourcemanager;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnMissingProperty;
import com.azure.spring.cloud.autoconfigure.resourcemanager.AzureResourceManagerAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.resourcemanager.AzureServiceResourceManagerConfigurationBase;
import com.azure.spring.cloud.autoconfigure.resourcemanager.EventHubsResourceMetadata;
import com.azure.spring.cloud.resourcemanager.connectionstring.EventHubsArmConnectionStringProvider;
import com.azure.spring.cloud.resourcemanager.provisioner.eventhubs.DefaultEventHubsProvisioner;
import com.azure.spring.cloud.resourcemanager.provisioner.eventhubs.EventHubsProvisioner;
import com.azure.spring.core.properties.resource.AzureResourceMetadata;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@ConditionalOnProperty(prefix="spring.cloud.azure.eventhubs", value={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnBean(value={AzureResourceManager.class})
@AutoConfigureAfter(value={AzureResourceManagerAutoConfiguration.class})
@EnableConfigurationProperties(value={EventHubsResourceMetadata.class})
public class AzureEventHubsResourceManagerAutoConfiguration
extends AzureServiceResourceManagerConfigurationBase {
    private final EventHubsResourceMetadata resourceMetadata;

    public AzureEventHubsResourceManagerAutoConfiguration(AzureResourceManager azureResourceManager, EventHubsResourceMetadata resourceMetadata) {
        super(azureResourceManager);
        this.resourceMetadata = resourceMetadata;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.azure.eventhubs", value={"namespace"})
    @ConditionalOnMissingProperty(prefix="spring.cloud.azure.eventhubs", value={"connection-string"})
    @Order
    public EventHubsArmConnectionStringProvider eventHubsArmConnectionStringProvider() {
        return new EventHubsArmConnectionStringProvider(this.azureResourceManager, (AzureResourceMetadata)this.resourceMetadata, this.resourceMetadata.getName());
    }

    @Bean
    @ConditionalOnMissingBean
    public EventHubsProvisioner eventHubsProvisioner() {
        return new DefaultEventHubsProvisioner(this.azureResourceManager, (AzureResourceMetadata)this.resourceMetadata);
    }
}

