/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.resourcemanager;

import com.azure.core.credential.TokenCredential;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.spring.cloud.autoconfigure.properties.AzureGlobalProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={AzureResourceManager.class})
@ConditionalOnExpression(value="${spring.cloud.azure.resource-manager.enabled:true}")
@ConditionalOnProperty(value={"spring.cloud.azure.profile.subscription-id"})
public class AzureResourceManagerAutoConfiguration {
    private final AzureGlobalProperties globalProperties;

    public AzureResourceManagerAutoConfiguration(AzureGlobalProperties globalProperties) {
        this.globalProperties = globalProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public AzureResourceManager azureResourceManager(TokenCredential tokenCredential, AzureProfile azureProfile) {
        return AzureResourceManager.configure().authenticate(tokenCredential, azureProfile).withDefaultSubscription();
    }

    @Bean
    @ConditionalOnMissingBean
    public AzureProfile azureProfile() {
        return new AzureProfile(this.globalProperties.getProfile().getTenantId(), this.globalProperties.getProfile().getSubscriptionId(), this.globalProperties.getProfile().getEnvironment().toManagementAzureEnvironment());
    }
}

