/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.resourcemanager;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnMissingProperty;
import com.azure.spring.cloud.autoconfigure.resourcemanager.AzureResourceManagerAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.resourcemanager.AzureServiceResourceManagerConfigurationBase;
import com.azure.spring.cloud.autoconfigure.resourcemanager.ServiceBusResourceMetadata;
import com.azure.spring.cloud.resourcemanager.connectionstring.ServiceBusArmConnectionStringProvider;
import com.azure.spring.cloud.resourcemanager.provisioner.servicebus.DefaultServiceBusProvisioner;
import com.azure.spring.cloud.resourcemanager.provisioner.servicebus.ServiceBusProvisioner;
import com.azure.spring.core.properties.resource.AzureResourceMetadata;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@ConditionalOnProperty(prefix="spring.cloud.azure.servicebus", value={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnBean(value={AzureResourceManager.class})
@AutoConfigureAfter(value={AzureResourceManagerAutoConfiguration.class})
@EnableConfigurationProperties(value={ServiceBusResourceMetadata.class})
public class AzureServiceBusResourceManagerAutoConfiguration
extends AzureServiceResourceManagerConfigurationBase {
    private final ServiceBusResourceMetadata resourceMetadata;

    public AzureServiceBusResourceManagerAutoConfiguration(AzureResourceManager azureResourceManager, ServiceBusResourceMetadata resourceMetadata) {
        super(azureResourceManager);
        this.resourceMetadata = resourceMetadata;
    }

    @Bean
    @ConditionalOnMissingBean
    public ServiceBusProvisioner serviceBusProvisioner() {
        return new DefaultServiceBusProvisioner(this.azureResourceManager, (AzureResourceMetadata)this.resourceMetadata);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.azure.servicebus", value={"namespace"})
    @ConditionalOnMissingProperty(prefix="spring.cloud.azure.servicebus", value={"connection-string"})
    @Order
    public ServiceBusArmConnectionStringProvider serviceBusArmConnectionStringProvider() {
        return new ServiceBusArmConnectionStringProvider(this.azureResourceManager, (AzureResourceMetadata)this.resourceMetadata, this.resourceMetadata.getName());
    }
}

