/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.resourcemanager;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.spring.cloud.autoconfigure.resourcemanager.AzureResourceManagerAutoConfiguration;
import com.azure.spring.cloud.autoconfigure.resourcemanager.AzureServiceResourceManagerConfigurationBase;
import com.azure.spring.cloud.autoconfigure.resourcemanager.StorageQueueResourceMetadata;
import com.azure.spring.cloud.resourcemanager.connectionstring.StorageQueueArmConnectionStringProvider;
import com.azure.spring.core.properties.resource.AzureResourceMetadata;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@ConditionalOnProperty(prefix="spring.cloud.azure.storage.queue", value={"enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={AzureResourceManager.class})
@AutoConfigureAfter(value={AzureResourceManagerAutoConfiguration.class})
@EnableConfigurationProperties(value={StorageQueueResourceMetadata.class})
public class AzureStorageQueueResourceManagerAutoConfiguration
extends AzureServiceResourceManagerConfigurationBase {
    private final StorageQueueResourceMetadata resourceMetadata;

    public AzureStorageQueueResourceManagerAutoConfiguration(AzureResourceManager azureResourceManager, StorageQueueResourceMetadata resourceMetadata) {
        super(azureResourceManager);
        this.resourceMetadata = resourceMetadata;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.azure.storage.queue", value={"account-name"})
    @Order
    public StorageQueueArmConnectionStringProvider storageQueueArmConnectionStringProvider() {
        return new StorageQueueArmConnectionStringProvider(this.azureResourceManager, (AzureResourceMetadata)this.resourceMetadata, this.resourceMetadata.getName());
    }
}

