/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.servicebus;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.servicebus.properties.AzureServiceBusProperties;
import com.azure.spring.core.AzureSpringIdentifier;
import com.azure.spring.core.connectionstring.ConnectionStringProvider;
import com.azure.spring.core.connectionstring.StaticConnectionStringProvider;
import com.azure.spring.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.core.service.AzureServiceType;
import com.azure.spring.service.servicebus.factory.ServiceBusClientBuilderFactory;
import com.azure.spring.service.servicebus.properties.ServiceBusCommonDescriptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ServiceBusClientBuilder.class})
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.servicebus", name={"connection-string", "namespace"})
class AzureServiceBusClientBuilderConfiguration {
    private final AzureServiceBusProperties serviceBusProperties;

    AzureServiceBusClientBuilderConfiguration(AzureServiceBusProperties serviceBusProperties) {
        this.serviceBusProperties = serviceBusProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ServiceBusClientBuilderFactory serviceBusClientBuilderFactory(ObjectProvider<ConnectionStringProvider<AzureServiceType.ServiceBus>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder>> customizers) {
        ServiceBusClientBuilderFactory factory = new ServiceBusClientBuilderFactory((ServiceBusCommonDescriptor)this.serviceBusProperties);
        factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_SERVICE_BUS);
        connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((ServiceBusClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
        customizers.orderedStream().forEach(arg_0 -> ((ServiceBusClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    public ServiceBusClientBuilder serviceBusClientBuilder(ServiceBusClientBuilderFactory factory) {
        return (ServiceBusClientBuilder)factory.build();
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.azure.servicebus.connection-string"})
    public StaticConnectionStringProvider<AzureServiceType.ServiceBus> staticServiceBusConnectionStringProvider() {
        return new StaticConnectionStringProvider((Object)AzureServiceType.SERVICE_BUS, this.serviceBusProperties.getConnectionString());
    }
}

