/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.servicebus;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusReceiverClient;
import com.azure.messaging.servicebus.ServiceBusSessionReceiverAsyncClient;
import com.azure.messaging.servicebus.ServiceBusSessionReceiverClient;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.servicebus.properties.AzureServiceBusProperties;
import com.azure.spring.core.AzureSpringIdentifier;
import com.azure.spring.core.connectionstring.ConnectionStringProvider;
import com.azure.spring.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.core.service.AzureServiceType;
import com.azure.spring.service.servicebus.factory.ServiceBusReceiverClientBuilderFactory;
import com.azure.spring.service.servicebus.factory.ServiceBusSessionReceiverClientBuilderFactory;
import com.azure.spring.service.servicebus.properties.ServiceBusConsumerDescriptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.servicebus", name={"entity-name", "consumer.entity-name"})
@Import(value={SessionConsumerClientConfiguration.class, NoneSessionConsumerClientConfiguration.class})
class AzureServiceBusConsumerClientConfiguration {
    AzureServiceBusConsumerClientConfiguration() {
    }

    private static boolean isDedicatedConnection(AzureServiceBusProperties.Consumer consumer) {
        return StringUtils.hasText((String)consumer.getNamespace()) || StringUtils.hasText((String)consumer.getConnectionString());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.cloud.azure.servicebus.consumer.session-enabled"}, havingValue="true")
    @ConditionalOnAnyProperty(prefix="spring.cloud.azure.servicebus", name={"entity-type", "consumer.entity-type"})
    static class SessionConsumerClientConfiguration {
        SessionConsumerClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceBusSessionReceiverClientBuilderFactory serviceBusSessionReceiverClientBuilderFactory(AzureServiceBusProperties serviceBusProperties, ObjectProvider<ServiceBusClientBuilder> serviceBusClientBuilders, ObjectProvider<ConnectionStringProvider<AzureServiceType.ServiceBus>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder>> customizers) {
            ServiceBusSessionReceiverClientBuilderFactory factory = AzureServiceBusConsumerClientConfiguration.isDedicatedConnection(serviceBusProperties.getConsumer()) ? new ServiceBusSessionReceiverClientBuilderFactory((ServiceBusConsumerDescriptor)serviceBusProperties.buildConsumerProperties()) : new ServiceBusSessionReceiverClientBuilderFactory((ServiceBusClientBuilder)serviceBusClientBuilders.getIfAvailable(), (ServiceBusConsumerDescriptor)serviceBusProperties.buildConsumerProperties());
            factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_SERVICE_BUS);
            connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((ServiceBusSessionReceiverClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
            customizers.orderedStream().forEach(arg_0 -> ((ServiceBusSessionReceiverClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
            return factory;
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder serviceBusSessionReceiverClientBuilder(ServiceBusSessionReceiverClientBuilderFactory builderFactory) {
            return (ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder)builderFactory.build();
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceBusSessionReceiverAsyncClient serviceBusSessionReceiverAsyncClient(ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder receiverClientBuilder) {
            return receiverClientBuilder.buildAsyncClient();
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceBusSessionReceiverClient serviceBusSessionReceiverClient(ServiceBusClientBuilder.ServiceBusSessionReceiverClientBuilder receiverClientBuilder) {
            return receiverClientBuilder.buildClient();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.cloud.azure.servicebus.consumer.session-enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnAnyProperty(prefix="spring.cloud.azure.servicebus", name={"entity-type", "consumer.entity-type"})
    static class NoneSessionConsumerClientConfiguration {
        NoneSessionConsumerClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceBusReceiverClientBuilderFactory serviceBusReceiverClientBuilderFactory(AzureServiceBusProperties serviceBusProperties, ObjectProvider<ServiceBusClientBuilder> serviceBusClientBuilders, ObjectProvider<ConnectionStringProvider<AzureServiceType.ServiceBus>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusReceiverClientBuilder>> customizers) {
            ServiceBusReceiverClientBuilderFactory factory = AzureServiceBusConsumerClientConfiguration.isDedicatedConnection(serviceBusProperties.getConsumer()) ? new ServiceBusReceiverClientBuilderFactory((ServiceBusConsumerDescriptor)serviceBusProperties.buildConsumerProperties()) : new ServiceBusReceiverClientBuilderFactory((ServiceBusClientBuilder)serviceBusClientBuilders.getIfAvailable(), (ServiceBusConsumerDescriptor)serviceBusProperties.buildConsumerProperties());
            factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_SERVICE_BUS);
            connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((ServiceBusReceiverClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
            customizers.orderedStream().forEach(arg_0 -> ((ServiceBusReceiverClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
            return factory;
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceBusClientBuilder.ServiceBusReceiverClientBuilder serviceBusReceiverClientBuilder(ServiceBusReceiverClientBuilderFactory builderFactory) {
            return (ServiceBusClientBuilder.ServiceBusReceiverClientBuilder)builderFactory.build();
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceBusReceiverAsyncClient serviceBusReceiverAsyncClient(ServiceBusClientBuilder.ServiceBusReceiverClientBuilder receiverClientBuilder) {
            return receiverClientBuilder.buildAsyncClient();
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceBusReceiverClient serviceBusReceiverClient(ServiceBusClientBuilder.ServiceBusReceiverClientBuilder receiverClientBuilder) {
            return receiverClientBuilder.buildClient();
        }
    }
}

