/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.servicebus;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusProcessorClient;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.servicebus.properties.AzureServiceBusProperties;
import com.azure.spring.core.AzureSpringIdentifier;
import com.azure.spring.core.connectionstring.ConnectionStringProvider;
import com.azure.spring.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.core.service.AzureServiceType;
import com.azure.spring.service.servicebus.factory.ServiceBusProcessorClientBuilderFactory;
import com.azure.spring.service.servicebus.factory.ServiceBusSessionProcessorClientBuilderFactory;
import com.azure.spring.service.servicebus.processor.MessageProcessingListener;
import com.azure.spring.service.servicebus.properties.ServiceBusProcessorDescriptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={MessageProcessingListener.class})
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.servicebus", name={"entity-name", "processor.entity-name"})
@Import(value={SessionProcessorClientConfiguration.class, NoneSessionProcessorClientConfiguration.class})
class AzureServiceBusProcessorClientConfiguration {
    AzureServiceBusProcessorClientConfiguration() {
    }

    private static boolean isDedicatedConnection(AzureServiceBusProperties.Processor processor) {
        return StringUtils.hasText((String)processor.getNamespace()) || StringUtils.hasText((String)processor.getConnectionString());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.cloud.azure.servicebus.processor.session-enabled"}, havingValue="true")
    @ConditionalOnAnyProperty(prefix="spring.cloud.azure.servicebus", name={"entity-type", "processor.entity-type"})
    static class SessionProcessorClientConfiguration {
        SessionProcessorClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceBusSessionProcessorClientBuilderFactory serviceBusSessionProcessorClientBuilderFactory(AzureServiceBusProperties serviceBusProperties, MessageProcessingListener listener, ObjectProvider<ServiceBusClientBuilder> serviceBusClientBuilders, ObjectProvider<ConnectionStringProvider<AzureServiceType.ServiceBus>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder>> customizers) {
            ServiceBusSessionProcessorClientBuilderFactory factory = AzureServiceBusProcessorClientConfiguration.isDedicatedConnection(serviceBusProperties.getProcessor()) ? new ServiceBusSessionProcessorClientBuilderFactory((ServiceBusProcessorDescriptor)serviceBusProperties.buildProcessorProperties(), listener) : new ServiceBusSessionProcessorClientBuilderFactory((ServiceBusClientBuilder)serviceBusClientBuilders.getIfAvailable(), (ServiceBusProcessorDescriptor)serviceBusProperties.buildProcessorProperties(), listener);
            factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_SERVICE_BUS);
            connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((ServiceBusSessionProcessorClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
            customizers.orderedStream().forEach(arg_0 -> ((ServiceBusSessionProcessorClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
            return factory;
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder serviceBusSessionProcessorClientBuilder(ServiceBusSessionProcessorClientBuilderFactory builderFactory) {
            return (ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder)builderFactory.build();
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceBusProcessorClient serviceBusProcessorClient(ServiceBusClientBuilder.ServiceBusSessionProcessorClientBuilder processorClientBuilder) {
            return processorClientBuilder.buildProcessorClient();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(value={"spring.cloud.azure.servicebus.processor.session-enabled"}, havingValue="false", matchIfMissing=true)
    @ConditionalOnAnyProperty(prefix="spring.cloud.azure.servicebus", name={"entity-type", "processor.entity-type"})
    static class NoneSessionProcessorClientConfiguration {
        NoneSessionProcessorClientConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceBusProcessorClientBuilderFactory serviceBusProcessorClientBuilderFactory(AzureServiceBusProperties serviceBusProperties, MessageProcessingListener listener, ObjectProvider<ServiceBusClientBuilder> serviceBusClientBuilders, ObjectProvider<ConnectionStringProvider<AzureServiceType.ServiceBus>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusProcessorClientBuilder>> customizers) {
            ServiceBusProcessorClientBuilderFactory factory = AzureServiceBusProcessorClientConfiguration.isDedicatedConnection(serviceBusProperties.getProcessor()) ? new ServiceBusProcessorClientBuilderFactory((ServiceBusProcessorDescriptor)serviceBusProperties.buildProcessorProperties(), listener) : new ServiceBusProcessorClientBuilderFactory((ServiceBusClientBuilder)serviceBusClientBuilders.getIfAvailable(), (ServiceBusProcessorDescriptor)serviceBusProperties.buildProcessorProperties(), listener);
            factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_SERVICE_BUS);
            connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((ServiceBusProcessorClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
            customizers.orderedStream().forEach(arg_0 -> ((ServiceBusProcessorClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
            return factory;
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceBusClientBuilder.ServiceBusProcessorClientBuilder serviceBusProcessorClientBuilder(ServiceBusProcessorClientBuilderFactory builderFactory) {
            return (ServiceBusClientBuilder.ServiceBusProcessorClientBuilder)builderFactory.build();
        }

        @Bean
        @ConditionalOnMissingBean
        public ServiceBusProcessorClient serviceBusProcessorClient(ServiceBusClientBuilder.ServiceBusProcessorClientBuilder processorClientBuilder) {
            return processorClientBuilder.buildProcessorClient();
        }
    }
}

