/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.servicebus;

import com.azure.messaging.servicebus.ServiceBusClientBuilder;
import com.azure.messaging.servicebus.ServiceBusSenderAsyncClient;
import com.azure.messaging.servicebus.ServiceBusSenderClient;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.servicebus.properties.AzureServiceBusProperties;
import com.azure.spring.core.AzureSpringIdentifier;
import com.azure.spring.core.connectionstring.ConnectionStringProvider;
import com.azure.spring.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.core.service.AzureServiceType;
import com.azure.spring.service.servicebus.factory.ServiceBusSenderClientBuilderFactory;
import com.azure.spring.service.servicebus.properties.ServiceBusProducerDescriptor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.servicebus", name={"entity-name", "producer.entity-name"})
class AzureServiceBusProducerClientConfiguration {
    AzureServiceBusProducerClientConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAnyProperty(prefix="spring.cloud.azure.servicebus", name={"entity-type", "producer.entity-type"})
    public ServiceBusSenderClientBuilderFactory serviceBusSenderClientBuilderFactory(AzureServiceBusProperties serviceBusProperties, ObjectProvider<ServiceBusClientBuilder> serviceBusClientBuilders, ObjectProvider<ConnectionStringProvider<AzureServiceType.ServiceBus>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<ServiceBusClientBuilder.ServiceBusSenderClientBuilder>> customizers) {
        ServiceBusSenderClientBuilderFactory factory = this.isDedicatedConnection(serviceBusProperties.getProducer()) ? new ServiceBusSenderClientBuilderFactory((ServiceBusProducerDescriptor)serviceBusProperties.buildProducerProperties()) : new ServiceBusSenderClientBuilderFactory((ServiceBusClientBuilder)serviceBusClientBuilders.getIfAvailable(), (ServiceBusProducerDescriptor)serviceBusProperties.buildProducerProperties());
        factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_SERVICE_BUS);
        connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((ServiceBusSenderClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
        customizers.orderedStream().forEach(arg_0 -> ((ServiceBusSenderClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={ServiceBusSenderClientBuilderFactory.class})
    public ServiceBusClientBuilder.ServiceBusSenderClientBuilder serviceBusSenderClientBuilder(ServiceBusSenderClientBuilderFactory builderFactory) {
        return (ServiceBusClientBuilder.ServiceBusSenderClientBuilder)builderFactory.build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={ServiceBusClientBuilder.ServiceBusSenderClientBuilder.class})
    public ServiceBusSenderAsyncClient serviceBusSenderAsyncClient(ServiceBusClientBuilder.ServiceBusSenderClientBuilder senderClientBuilder) {
        return senderClientBuilder.buildAsyncClient();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={ServiceBusClientBuilder.ServiceBusSenderClientBuilder.class})
    public ServiceBusSenderClient serviceBusSenderClient(ServiceBusClientBuilder.ServiceBusSenderClientBuilder senderClientBuilder) {
        return senderClientBuilder.buildClient();
    }

    private boolean isDedicatedConnection(AzureServiceBusProperties.Producer producer) {
        return StringUtils.hasText((String)producer.getNamespace()) || StringUtils.hasText((String)producer.getConnectionString());
    }
}

