/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.servicebus.properties;

import com.azure.spring.cloud.autoconfigure.properties.AbstractAzureAmqpCP;
import com.azure.spring.core.connectionstring.implementation.ServiceBusConnectionString;
import com.azure.spring.service.servicebus.properties.ServiceBusEntityType;

public abstract class AzureServiceBusCommonProperties
extends AbstractAzureAmqpCP {
    protected String domainName = "servicebus.windows.net";
    protected String namespace;
    protected String connectionString;
    private String entityName;
    private ServiceBusEntityType entityType;

    private String extractFqdnFromConnectionString() {
        if (this.connectionString == null) {
            return null;
        }
        return new ServiceBusConnectionString(this.connectionString).getFullyQualifiedNamespace();
    }

    public String getFQDN() {
        return this.namespace == null ? this.extractFqdnFromConnectionString() : this.namespace + "." + this.domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String name) {
        this.entityName = name;
    }

    public ServiceBusEntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(ServiceBusEntityType type) {
        this.entityType = type;
    }
}

