/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.servicebus.properties;

import com.azure.messaging.servicebus.models.ServiceBusReceiveMode;
import com.azure.messaging.servicebus.models.SubQueue;
import com.azure.spring.cloud.autoconfigure.servicebus.properties.AzureServiceBusCommonProperties;
import com.azure.spring.core.properties.AzureProperties;
import com.azure.spring.core.properties.util.AzurePropertiesUtils;
import com.azure.spring.service.servicebus.properties.ServiceBusConsumerDescriptor;
import com.azure.spring.service.servicebus.properties.ServiceBusNamespaceDescriptor;
import com.azure.spring.service.servicebus.properties.ServiceBusProcessorDescriptor;
import com.azure.spring.service.servicebus.properties.ServiceBusProducerDescriptor;
import java.time.Duration;
import org.springframework.boot.context.properties.PropertyMapper;

public class AzureServiceBusProperties
extends AzureServiceBusCommonProperties
implements ServiceBusNamespaceDescriptor {
    public static final String PREFIX = "spring.cloud.azure.servicebus";
    private Boolean crossEntityTransactions;
    private final Producer producer = new Producer();
    private final Consumer consumer = new Consumer();
    private final Processor processor = new Processor();

    public Boolean getCrossEntityTransactions() {
        return this.crossEntityTransactions;
    }

    public void setCrossEntityTransactions(Boolean crossEntityTransactions) {
        this.crossEntityTransactions = crossEntityTransactions;
    }

    public Producer getProducer() {
        return this.producer;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public Producer buildProducerProperties() {
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        Producer properties = new Producer();
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)this, (AzureProperties)this.producer, (AzureProperties)properties);
        propertyMapper.from((Object)this.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.getEntityName()).to(properties::setEntityName);
        propertyMapper.from((Object)this.getEntityType()).to(properties::setEntityType);
        propertyMapper.from((Object)this.producer.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.producer.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.producer.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.producer.getEntityType()).to(properties::setEntityType);
        propertyMapper.from((Object)this.producer.getEntityName()).to(properties::setEntityName);
        return properties;
    }

    public Consumer buildConsumerProperties() {
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        Consumer properties = new Consumer();
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)this, (AzureProperties)this.consumer, (AzureProperties)properties);
        propertyMapper.from((Object)this.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.getEntityName()).to(properties::setEntityName);
        propertyMapper.from((Object)this.getEntityType()).to(properties::setEntityType);
        propertyMapper.from((Object)this.consumer.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.consumer.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.consumer.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.consumer.getEntityType()).to(properties::setEntityType);
        propertyMapper.from((Object)this.consumer.getEntityName()).to(properties::setEntityName);
        propertyMapper.from((Object)this.consumer.getSessionEnabled()).to(properties::setSessionEnabled);
        propertyMapper.from((Object)this.consumer.getAutoComplete()).to(properties::setAutoComplete);
        propertyMapper.from((Object)this.consumer.getPrefetchCount()).to(properties::setPrefetchCount);
        propertyMapper.from((Object)this.consumer.getSubQueue()).to(properties::setSubQueue);
        propertyMapper.from((Object)this.consumer.getReceiveMode()).to(properties::setReceiveMode);
        propertyMapper.from((Object)this.consumer.getSubscriptionName()).to(properties::setSubscriptionName);
        propertyMapper.from((Object)this.consumer.getMaxAutoLockRenewDuration()).to(properties::setMaxAutoLockRenewDuration);
        return properties;
    }

    public Processor buildProcessorProperties() {
        PropertyMapper propertyMapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        Processor properties = new Processor();
        AzurePropertiesUtils.mergeAzureCommonProperties((AzureProperties)this, (AzureProperties)this.processor, (AzureProperties)properties);
        propertyMapper.from((Object)this.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.getEntityName()).to(properties::setEntityName);
        propertyMapper.from((Object)this.getEntityType()).to(properties::setEntityType);
        propertyMapper.from((Object)this.processor.getDomainName()).to(properties::setDomainName);
        propertyMapper.from((Object)this.processor.getNamespace()).to(properties::setNamespace);
        propertyMapper.from((Object)this.processor.getConnectionString()).to(properties::setConnectionString);
        propertyMapper.from((Object)this.processor.getEntityType()).to(properties::setEntityType);
        propertyMapper.from((Object)this.processor.getEntityName()).to(properties::setEntityName);
        propertyMapper.from((Object)this.processor.getSessionEnabled()).to(properties::setSessionEnabled);
        propertyMapper.from((Object)this.processor.getAutoComplete()).to(properties::setAutoComplete);
        propertyMapper.from((Object)this.processor.getPrefetchCount()).to(properties::setPrefetchCount);
        propertyMapper.from((Object)this.processor.getSubQueue()).to(properties::setSubQueue);
        propertyMapper.from((Object)this.processor.getReceiveMode()).to(properties::setReceiveMode);
        propertyMapper.from((Object)this.processor.getSubscriptionName()).to(properties::setSubscriptionName);
        propertyMapper.from((Object)this.processor.getMaxAutoLockRenewDuration()).to(properties::setMaxAutoLockRenewDuration);
        propertyMapper.from((Object)this.processor.getMaxConcurrentCalls()).to(properties::setMaxConcurrentCalls);
        propertyMapper.from((Object)this.processor.getMaxConcurrentSessions()).to(properties::setMaxConcurrentSessions);
        return properties;
    }

    public static class Processor
    extends Consumer
    implements ServiceBusProcessorDescriptor {
        private Integer maxConcurrentCalls;
        private Integer maxConcurrentSessions;

        public Integer getMaxConcurrentCalls() {
            return this.maxConcurrentCalls;
        }

        public void setMaxConcurrentCalls(Integer maxConcurrentCalls) {
            this.maxConcurrentCalls = maxConcurrentCalls;
        }

        public Integer getMaxConcurrentSessions() {
            return this.maxConcurrentSessions;
        }

        public void setMaxConcurrentSessions(Integer maxConcurrentSessions) {
            this.maxConcurrentSessions = maxConcurrentSessions;
        }
    }

    public static class Consumer
    extends AzureServiceBusCommonProperties
    implements ServiceBusConsumerDescriptor {
        private Boolean sessionEnabled;
        private Boolean autoComplete;
        private Integer prefetchCount;
        private SubQueue subQueue;
        private ServiceBusReceiveMode receiveMode = ServiceBusReceiveMode.PEEK_LOCK;
        private String subscriptionName;
        private Duration maxAutoLockRenewDuration;

        public Boolean getSessionEnabled() {
            return this.sessionEnabled;
        }

        public void setSessionEnabled(Boolean sessionEnabled) {
            this.sessionEnabled = sessionEnabled;
        }

        public Boolean getAutoComplete() {
            return this.autoComplete;
        }

        public void setAutoComplete(Boolean autoComplete) {
            this.autoComplete = autoComplete;
        }

        public Integer getPrefetchCount() {
            return this.prefetchCount;
        }

        public void setPrefetchCount(Integer prefetchCount) {
            this.prefetchCount = prefetchCount;
        }

        public SubQueue getSubQueue() {
            return this.subQueue;
        }

        public void setSubQueue(SubQueue subQueue) {
            this.subQueue = subQueue;
        }

        public ServiceBusReceiveMode getReceiveMode() {
            return this.receiveMode;
        }

        public void setReceiveMode(ServiceBusReceiveMode receiveMode) {
            this.receiveMode = receiveMode;
        }

        public String getSubscriptionName() {
            return this.subscriptionName;
        }

        public void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        public Duration getMaxAutoLockRenewDuration() {
            return this.maxAutoLockRenewDuration;
        }

        public void setMaxAutoLockRenewDuration(Duration maxAutoLockRenewDuration) {
            this.maxAutoLockRenewDuration = maxAutoLockRenewDuration;
        }
    }

    public static class Producer
    extends AzureServiceBusCommonProperties
    implements ServiceBusProducerDescriptor {
    }
}

