/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.storage;

import com.azure.spring.cloud.autoconfigure.storage.queue.AzureStorageQueueAutoConfiguration;
import com.azure.spring.storage.queue.core.DefaultStorageQueueClientFactory;
import com.azure.spring.storage.queue.core.StorageQueueClientFactory;
import com.azure.spring.storage.queue.core.StorageQueueOperation;
import com.azure.spring.storage.queue.core.StorageQueueTemplate;
import com.azure.storage.queue.QueueServiceAsyncClient;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={StorageQueueClientFactory.class})
@ConditionalOnProperty(value={"spring.cloud.azure.storage.queue.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnBean(value={QueueServiceAsyncClient.class})
@AutoConfigureAfter(value={AzureStorageQueueAutoConfiguration.class})
public class AzureStorageQueueOperationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public StorageQueueClientFactory storageQueueClientFactory(QueueServiceAsyncClient queueServiceAsyncClient) {
        return new DefaultStorageQueueClientFactory(queueServiceAsyncClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public StorageQueueOperation storageQueueOperation(StorageQueueClientFactory storageQueueClientFactory) {
        return new StorageQueueTemplate(storageQueueClientFactory);
    }
}

