/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.storage.fileshare.properties;

import com.azure.spring.cloud.autoconfigure.storage.common.AzureStorageProperties;
import com.azure.spring.service.storage.fileshare.StorageFileShareProperties;
import com.azure.storage.file.share.ShareServiceVersion;

public class AzureStorageFileShareProperties
extends AzureStorageProperties
implements StorageFileShareProperties {
    public static final String PREFIX = "spring.cloud.azure.storage.fileshare";
    public static final String FILE_ENDPOINT_PATTERN = "https://%s.file%s";
    private ShareServiceVersion serviceVersion;
    private String shareName;
    private String fileName;

    @Override
    public String getEndpoint() {
        return this.endpoint == null ? this.buildEndpointFromAccountName() : this.endpoint;
    }

    private String buildEndpointFromAccountName() {
        return String.format(FILE_ENDPOINT_PATTERN, this.accountName, this.profile.getEnvironment().getStorageEndpointSuffix());
    }

    public ShareServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public void setServiceVersion(ShareServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public String getShareName() {
        return this.shareName;
    }

    public void setShareName(String shareName) {
        this.shareName = shareName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

