/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.storage.queue.properties;

import com.azure.spring.cloud.autoconfigure.storage.common.AzureStorageProperties;
import com.azure.spring.service.storage.queue.StorageQueueProperties;
import com.azure.storage.queue.QueueServiceVersion;

public class AzureStorageQueueProperties
extends AzureStorageProperties
implements StorageQueueProperties {
    public static final String PREFIX = "spring.cloud.azure.storage.queue";
    public static final String QUEUE_ENDPOINT_PATTERN = "https://%s.queue%s";
    private QueueServiceVersion serviceVersion;
    private String messageEncoding;

    @Override
    public String getEndpoint() {
        return this.endpoint == null ? this.buildEndpointFromAccountName() : this.endpoint;
    }

    private String buildEndpointFromAccountName() {
        return String.format(QUEUE_ENDPOINT_PATTERN, this.accountName, this.profile.getEnvironment().getStorageEndpointSuffix());
    }

    public QueueServiceVersion getServiceVersion() {
        return this.serviceVersion;
    }

    public void setServiceVersion(QueueServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public String getMessageEncoding() {
        return this.messageEncoding;
    }

    public void setMessageEncoding(String messageEncoding) {
        this.messageEncoding = messageEncoding;
    }
}

