/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.trace.sleuth;

import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.spring.core.trace.sleuth.AzureHttpClientBuilderFactoryBeanPostProcessor;
import com.azure.spring.tracing.sleuth.SleuthHttpPolicy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;

@Role(value=2)
@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SleuthHttpPolicy.class, Tracer.class})
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
public class AzureSleuthAutoConfiguration {
    @Bean(name={"sleuthHttpPolicy"})
    @ConditionalOnMissingBean(name={"sleuthHttpPolicy"})
    public HttpPipelinePolicy sleuthHttpPolicy(Tracer tracer, Propagator propagator) {
        return new SleuthHttpPolicy(tracer, propagator);
    }

    @Role(value=2)
    @Bean
    @ConditionalOnMissingBean
    public AzureHttpClientBuilderFactoryBeanPostProcessor httpClientBuilderFactoryBeanPostProcessor() {
        return new AzureHttpClientBuilderFactoryBeanPostProcessor();
    }
}

