/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad;

import com.azure.spring.cloud.autoconfigure.aad.implementation.jwt.AadJwtGrantedAuthoritiesConverter;
import com.azure.spring.cloud.autoconfigure.aad.implementation.oauth2.AadOAuth2AuthenticatedPrincipal;
import com.azure.spring.cloud.autoconfigure.aad.properties.AadResourceServerProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.util.Assert;

public class AadJwtBearerTokenAuthenticationConverter
implements Converter<Jwt, AbstractAuthenticationToken> {
    private final Converter<Jwt, Collection<GrantedAuthority>> converter;
    private final String principalClaimName;

    public AadJwtBearerTokenAuthenticationConverter() {
        this("sub", AadResourceServerProperties.DEFAULT_CLAIM_TO_AUTHORITY_PREFIX_MAP);
    }

    public AadJwtBearerTokenAuthenticationConverter(String authoritiesClaimName) {
        this(authoritiesClaimName, "SCOPE_");
    }

    public AadJwtBearerTokenAuthenticationConverter(String authoritiesClaimName, String authorityPrefix) {
        this(null, AadJwtBearerTokenAuthenticationConverter.buildClaimToAuthorityPrefixMap(authoritiesClaimName, authorityPrefix));
    }

    public AadJwtBearerTokenAuthenticationConverter(String principalClaimName, Map<String, String> claimToAuthorityPrefixMap) {
        Assert.notNull(claimToAuthorityPrefixMap, (String)"claimToAuthorityPrefixMap cannot be null");
        this.principalClaimName = principalClaimName;
        this.converter = new AadJwtGrantedAuthoritiesConverter(claimToAuthorityPrefixMap);
    }

    public AbstractAuthenticationToken convert(Jwt jwt) {
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, jwt.getTokenValue(), jwt.getIssuedAt(), jwt.getExpiresAt());
        Map claims = jwt.getClaims();
        Collection authorities = (Collection)this.converter.convert((Object)jwt);
        AadOAuth2AuthenticatedPrincipal principal = new AadOAuth2AuthenticatedPrincipal(jwt.getHeaders(), claims, authorities, jwt.getTokenValue(), (String)claims.get(this.principalClaimName));
        return new BearerTokenAuthentication((OAuth2AuthenticatedPrincipal)principal, accessToken, authorities);
    }

    private static Map<String, String> buildClaimToAuthorityPrefixMap(String authoritiesClaimName, String authorityPrefix) {
        Assert.notNull((Object)authoritiesClaimName, (String)"authoritiesClaimName cannot be null");
        Assert.notNull((Object)authorityPrefix, (String)"authorityPrefix cannot be null");
        HashMap<String, String> claimToAuthorityPrefixMap = new HashMap<String, String>();
        claimToAuthorityPrefixMap.put(authoritiesClaimName, authorityPrefix);
        return claimToAuthorityPrefixMap;
    }
}

