/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aadb2c.implementation;

import com.azure.spring.cloud.autoconfigure.aadb2c.implementation.AadB2cConfigurationException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.springframework.util.Assert;

public final class AadB2cUrl {
    private static final String AUTHORIZATION_URL_PATTERN = "oauth2/v2.0/authorize";
    private static final String TOKEN_URL_PATTERN = "oauth2/v2.0/token?p=";
    private static final String JWKSET_URL_PATTERN = "discovery/v2.0/keys?p=";
    private static final String END_SESSION_URL_PATTERN = "oauth2/v2.0/logout?post_logout_redirect_uri=%s&p=%s";
    private static final String AAD_TOKEN_URL_PATTERN = "https://login.microsoftonline.com/%s/oauth2/v2.0/token";
    private static final String AAD_JWKSET_URL_PATTERN = "https://login.microsoftonline.com/%s/discovery/v2.0/keys";

    private AadB2cUrl() {
    }

    public static String getAuthorizationUrl(String baseUri) {
        return AadB2cUrl.addSlash(baseUri) + AUTHORIZATION_URL_PATTERN;
    }

    public static String getTokenUrl(String baseUri, String userFlow) {
        Assert.hasText((String)userFlow, (String)"user flow should have text.");
        return AadB2cUrl.addSlash(baseUri) + TOKEN_URL_PATTERN + userFlow;
    }

    public static String getAADTokenUrl(String tenantId) {
        Assert.hasText((String)tenantId, (String)"tenantId should have text.");
        return String.format(AAD_TOKEN_URL_PATTERN, tenantId);
    }

    public static String getAADJwkSetUrl(String tenantId) {
        Assert.hasText((String)tenantId, (String)"tenantId should have text.");
        return String.format(AAD_JWKSET_URL_PATTERN, tenantId);
    }

    public static String getJwkSetUrl(String baseUri, String userFlow) {
        Assert.hasText((String)userFlow, (String)"user flow should have text.");
        return AadB2cUrl.addSlash(baseUri) + JWKSET_URL_PATTERN + userFlow;
    }

    public static String getEndSessionUrl(String baseUri, String logoutUrl, String userFlow) {
        Assert.hasText((String)logoutUrl, (String)"logoutUrl should have text.");
        Assert.hasText((String)userFlow, (String)"user flow should have text.");
        return AadB2cUrl.addSlash(baseUri) + String.format(END_SESSION_URL_PATTERN, AadB2cUrl.getEncodedURL(logoutUrl), userFlow);
    }

    private static String getEncodedURL(String url) {
        Assert.hasText((String)url, (String)"url should have text.");
        try {
            return URLEncoder.encode(url, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AadB2cConfigurationException("failed to encode url: " + url, e);
        }
    }

    private static String addSlash(String uri) {
        return uri.endsWith("/") ? uri : uri + "/";
    }
}

