/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.implementation.webapi;

import com.azure.spring.cloud.autoconfigure.aad.properties.AadAuthorizationGrantType;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.aad.msal4j.MsalInteractionRequiredException;
import com.microsoft.aad.msal4j.MsalServiceException;
import com.microsoft.aad.msal4j.OnBehalfOfParameters;
import com.microsoft.aad.msal4j.UserAssertion;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizationContext;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AbstractOAuth2Token;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AadOboOAuth2AuthorizedClientProvider
implements OAuth2AuthorizedClientProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AadOboOAuth2AuthorizedClientProvider.class);
    private final Clock clock = Clock.systemUTC();
    private final Duration clockSkew = Duration.ofSeconds(60L);

    public OAuth2AuthorizedClient authorize(OAuth2AuthorizationContext context) {
        Assert.notNull((Object)context, (String)"context cannot be null");
        ClientRegistration clientRegistration = context.getClientRegistration();
        if (!AadAuthorizationGrantType.ON_BEHALF_OF.isSameGrantType(clientRegistration.getAuthorizationGrantType())) {
            return null;
        }
        OAuth2AuthorizedClient authorizedClient = context.getAuthorizedClient();
        if (authorizedClient != null && !this.hasTokenExpired((AbstractOAuth2Token)authorizedClient.getAccessToken())) {
            return null;
        }
        return this.getOboAuthorizedClient(context.getClientRegistration(), context.getPrincipal());
    }

    private boolean hasTokenExpired(AbstractOAuth2Token token) {
        Instant expiresAt = token.getExpiresAt();
        if (expiresAt == null) {
            return true;
        }
        expiresAt = expiresAt.minus(this.clockSkew);
        return this.clock.instant().isAfter(expiresAt);
    }

    private <T extends OAuth2AuthorizedClient> T getOboAuthorizedClient(ClientRegistration clientRegistration, Authentication principal) {
        if (principal instanceof AnonymousAuthenticationToken) {
            LOGGER.debug("Found anonymous authentication.");
            return null;
        }
        if (!(principal instanceof AbstractOAuth2TokenAuthenticationToken)) {
            throw new IllegalStateException("Unsupported token implementation " + principal.getClass());
        }
        try {
            String accessToken = ((AbstractOAuth2TokenAuthenticationToken)principal).getToken().getTokenValue();
            OnBehalfOfParameters parameters = OnBehalfOfParameters.builder((Set)clientRegistration.getScopes(), (UserAssertion)new UserAssertion(accessToken)).build();
            ConfidentialClientApplication clientApplication = this.createApp(clientRegistration);
            if (null == clientApplication) {
                return null;
            }
            String oboAccessToken = ((IAuthenticationResult)clientApplication.acquireToken(parameters).get()).accessToken();
            JWT parser = JWTParser.parse((String)oboAccessToken);
            Date iat = (Date)parser.getJWTClaimsSet().getClaim("iat");
            Date exp = (Date)parser.getJWTClaimsSet().getClaim("exp");
            OAuth2AccessToken oAuth2AccessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, oboAccessToken, Instant.ofEpochMilli(iat.getTime()), Instant.ofEpochMilli(exp.getTime()));
            OAuth2AuthorizedClient oAuth2AuthorizedClient = new OAuth2AuthorizedClient(clientRegistration, principal.getName(), oAuth2AccessToken);
            LOGGER.info("load obo authorized client success");
            return (T)oAuth2AuthorizedClient;
        }
        catch (ExecutionException exception) {
            Optional.of(exception).map(Throwable::getCause).filter(e -> e instanceof MsalInteractionRequiredException).map(e -> (MsalInteractionRequiredException)e).map(MsalServiceException::claims).filter(StringUtils::hasText).ifPresent(this::replyForbiddenWithWwwAuthenticateHeader);
            LOGGER.error("Failed to load authorized client.", (Throwable)exception);
        }
        catch (InterruptedException | ParseException exception) {
            LOGGER.error("Failed to load authorized client.", (Throwable)exception);
        }
        return null;
    }

    ConfidentialClientApplication createApp(ClientRegistration clientRegistration) {
        String authorizationUri = clientRegistration.getProviderDetails().getAuthorizationUri();
        String authority = this.interceptAuthorizationUri(authorizationUri);
        IClientSecret clientCredential = ClientCredentialFactory.createFromSecret((String)clientRegistration.getClientSecret());
        try {
            return ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)clientRegistration.getClientId(), (IClientCredential)clientCredential).authority(authority)).build();
        }
        catch (MalformedURLException e) {
            LOGGER.error("Failed to create ConfidentialClientApplication", (Throwable)e);
            return null;
        }
    }

    private String interceptAuthorizationUri(String authorizationUri) {
        int count = 0;
        int slashNumber = 4;
        for (int i = 0; i < authorizationUri.length(); ++i) {
            if (authorizationUri.charAt(i) == '/') {
                ++count;
            }
            if (count != slashNumber) continue;
            return authorizationUri.substring(0, i + 1);
        }
        return null;
    }

    private void replyForbiddenWithWwwAuthenticateHeader(String claims) {
        ServletRequestAttributes attr = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletResponse response = attr.getResponse();
        Assert.notNull((Object)response, (String)"HttpServletResponse should not be null.");
        response.setStatus(HttpStatus.FORBIDDEN.value());
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("CONDITIONAL_ACCESS_POLICY_CLAIMS", claims);
        parameters.put("error", "invalid_token");
        parameters.put("error_description", "The resource server requires higher privileges than provided by the access token");
        response.addHeader("WWW-Authenticate", "Bearer " + parameters);
    }
}

