/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.condition;

import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.condition.PropertyCondition;
import com.azure.spring.cloud.core.implementation.util.AzureStringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class OnAnyPropertyCondition
extends PropertyCondition {
    OnAnyPropertyCondition() {
    }

    @Override
    protected String getAnnotationName() {
        return ConditionalOnAnyProperty.class.getName();
    }

    @Override
    protected ConditionOutcome determineOutcome(AnnotationAttributes annotationAttributes, PropertyResolver resolver) {
        Spec spec = new Spec(annotationAttributes);
        ArrayList missingProperties = new ArrayList();
        ArrayList nonMatchingProperties = new ArrayList();
        ArrayList matchingProperties = new ArrayList();
        spec.collectProperties(resolver, missingProperties, nonMatchingProperties, matchingProperties);
        if (matchingProperties.isEmpty()) {
            if (!missingProperties.isEmpty()) {
                return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnAnyProperty.class, (Object[])new Object[]{spec}).didNotFind("property", "properties").items(ConditionMessage.Style.QUOTE, missingProperties));
            }
            if (!nonMatchingProperties.isEmpty()) {
                return ConditionOutcome.noMatch((ConditionMessage)ConditionMessage.forCondition(ConditionalOnAnyProperty.class, (Object[])new Object[]{spec}).found("different value in property", "different value in properties").items(ConditionMessage.Style.QUOTE, nonMatchingProperties));
            }
        }
        return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition(ConditionalOnAnyProperty.class, (Object[])new Object[]{spec}).because("matched"));
    }

    private static class Spec {
        private final String prefix;
        private final String havingValue;
        private final String[] names;
        private final boolean matchIfMissing;

        Spec(AnnotationAttributes annotationAttributes) {
            String prefixAttr = annotationAttributes.getString("prefix");
            this.prefix = AzureStringUtils.ensureEndsWithSuffix((String)prefixAttr.trim(), (String)".");
            this.havingValue = annotationAttributes.getString("havingValue");
            this.names = this.getNames((Map<String, Object>)annotationAttributes);
            this.matchIfMissing = annotationAttributes.getBoolean("matchIfMissing");
        }

        private String[] getNames(Map<String, Object> annotationAttributes) {
            String[] value = (String[])annotationAttributes.get("value");
            String[] name = (String[])annotationAttributes.get("name");
            Assert.state((value.length > 0 || name.length > 0 ? 1 : 0) != 0, (String)"The name or value attribute of @ConditionalOnAnyProperty must be specified");
            Assert.state((value.length == 0 || name.length == 0 ? 1 : 0) != 0, (String)"The name and value attributes of @ConditionalOnAnyProperty are exclusive");
            return value.length > 0 ? value : name;
        }

        private void collectProperties(PropertyResolver resolver, List<String> missing, List<String> nonMatching, List<String> matching) {
            for (String name : this.names) {
                String key = this.prefix + name;
                if (resolver.containsProperty(key)) {
                    if (!this.isMatch(resolver.getProperty(key), this.havingValue)) {
                        nonMatching.add(name);
                        continue;
                    }
                    matching.add(name);
                    continue;
                }
                if (!this.matchIfMissing) {
                    missing.add(name);
                    continue;
                }
                matching.add(name);
            }
        }

        private boolean isMatch(String value, String requiredValue) {
            if (StringUtils.hasLength((String)requiredValue)) {
                return requiredValue.equalsIgnoreCase(value);
            }
            return !"false".equalsIgnoreCase(value);
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("(");
            result.append(this.prefix);
            if (this.names.length == 1) {
                result.append(this.names[0]);
            } else {
                result.append("[");
                result.append(StringUtils.arrayToCommaDelimitedString((Object[])this.names));
                result.append("]");
            }
            if (StringUtils.hasLength((String)this.havingValue)) {
                result.append("=").append(this.havingValue);
            }
            result.append(")");
            return result.toString();
        }
    }
}

