/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.context;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientCertificateCredentialBuilder;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.DefaultAzureCredentialBuilder;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.identity.UsernamePasswordCredentialBuilder;
import com.azure.spring.cloud.autoconfigure.AzureServiceConfigurationBase;
import com.azure.spring.cloud.autoconfigure.context.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.properties.core.AbstractAzureHttpConfigurationProperties;
import com.azure.spring.cloud.core.credential.AzureCredentialResolver;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.credential.resolver.AzureTokenCredentialResolver;
import com.azure.spring.cloud.core.implementation.factory.AbstractAzureServiceClientBuilderFactory;
import com.azure.spring.cloud.core.implementation.factory.credential.AbstractAzureCredentialBuilderFactory;
import com.azure.spring.cloud.core.implementation.factory.credential.ClientCertificateCredentialBuilderFactory;
import com.azure.spring.cloud.core.implementation.factory.credential.ClientSecretCredentialBuilderFactory;
import com.azure.spring.cloud.core.implementation.factory.credential.DefaultAzureCredentialBuilderFactory;
import com.azure.spring.cloud.core.implementation.factory.credential.ManagedIdentityCredentialBuilderFactory;
import com.azure.spring.cloud.core.implementation.factory.credential.UsernamePasswordCredentialBuilderFactory;
import com.azure.spring.cloud.core.properties.AzureProperties;
import com.azure.spring.cloud.core.provider.authentication.TokenCredentialOptionsProvider;
import java.util.concurrent.ExecutorService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.boot.task.TaskExecutorBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={TaskExecutionAutoConfiguration.class})
public class AzureTokenCredentialAutoConfiguration
extends AzureServiceConfigurationBase {
    private final IdentityClientProperties identityClientProperties;

    AzureTokenCredentialAutoConfiguration(AzureGlobalProperties azureGlobalProperties) {
        super(azureGlobalProperties);
        this.identityClientProperties = this.loadProperties(azureGlobalProperties, new IdentityClientProperties());
    }

    @ConditionalOnMissingBean(name={"springCloudAzureDefaultCredential"})
    @Bean(name={"springCloudAzureDefaultCredential"})
    @Order
    TokenCredential tokenCredential(DefaultAzureCredentialBuilderFactory factory, AzureTokenCredentialResolver resolver) {
        TokenCredential globalTokenCredential = resolver.resolve((AzureProperties)this.identityClientProperties);
        if (globalTokenCredential != null) {
            return globalTokenCredential;
        }
        return ((DefaultAzureCredentialBuilder)factory.build()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    DefaultAzureCredentialBuilderFactory azureCredentialBuilderFactory(ObjectProvider<AzureServiceClientBuilderCustomizer<DefaultAzureCredentialBuilder>> customizers, @Qualifier(value="springCloudAzureCredentialTaskExecutor") ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        DefaultAzureCredentialBuilderFactory factory = new DefaultAzureCredentialBuilderFactory((AzureProperties)this.identityClientProperties);
        factory.setExecutorService((ExecutorService)threadPoolTaskExecutor.getThreadPoolExecutor());
        customizers.orderedStream().forEach(arg_0 -> ((DefaultAzureCredentialBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    AzureTokenCredentialResolver azureTokenCredentialResolver(ClientSecretCredentialBuilderFactory clientSecretCredentialBuilderFactory, ClientCertificateCredentialBuilderFactory clientCertificateCredentialBuilderFactory, UsernamePasswordCredentialBuilderFactory usernamePasswordCredentialBuilderFactory, ManagedIdentityCredentialBuilderFactory managedIdentityCredentialBuilderFactory) {
        return new AzureTokenCredentialResolver(azureProperties -> {
            if (azureProperties.getCredential() == null) {
                return null;
            }
            TokenCredentialOptionsProvider.TokenCredentialOptions properties = azureProperties.getCredential();
            String tenantId = azureProperties.getProfile().getTenantId();
            String clientId = properties.getClientId();
            boolean isClientIdSet = StringUtils.hasText((String)clientId);
            if (StringUtils.hasText((String)tenantId)) {
                if (isClientIdSet && StringUtils.hasText((String)properties.getClientSecret())) {
                    return ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)clientSecretCredentialBuilderFactory.build()).clientId(clientId)).clientSecret(properties.getClientSecret()).tenantId(tenantId)).build();
                }
                String clientCertificatePath = properties.getClientCertificatePath();
                if (StringUtils.hasText((String)clientCertificatePath)) {
                    ClientCertificateCredentialBuilder builder = (ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)((ClientCertificateCredentialBuilder)clientCertificateCredentialBuilderFactory.build()).tenantId(tenantId)).clientId(clientId);
                    if (StringUtils.hasText((String)properties.getClientCertificatePassword())) {
                        builder.pfxCertificate(clientCertificatePath, properties.getClientCertificatePassword());
                    } else {
                        builder.pemCertificate(clientCertificatePath);
                    }
                    return builder.build();
                }
            }
            if (isClientIdSet && StringUtils.hasText((String)properties.getUsername()) && StringUtils.hasText((String)properties.getPassword())) {
                return ((UsernamePasswordCredentialBuilder)((UsernamePasswordCredentialBuilder)((UsernamePasswordCredentialBuilder)usernamePasswordCredentialBuilderFactory.build()).username(properties.getUsername()).password(properties.getPassword()).clientId(clientId)).tenantId(tenantId)).build();
            }
            if (properties.isManagedIdentityEnabled()) {
                ManagedIdentityCredentialBuilder builder = (ManagedIdentityCredentialBuilder)managedIdentityCredentialBuilderFactory.build();
                if (isClientIdSet) {
                    builder.clientId(clientId);
                }
                return builder.build();
            }
            return null;
        });
    }

    @Bean
    @ConditionalOnMissingBean
    ClientSecretCredentialBuilderFactory clientSecretCredentialBuilderFactory(@Qualifier(value="springCloudAzureCredentialTaskExecutor") ThreadPoolTaskExecutor threadPoolTaskExecutor, ObjectProvider<AzureServiceClientBuilderCustomizer<ClientSecretCredentialBuilder>> customizers) {
        ClientSecretCredentialBuilderFactory factory = new ClientSecretCredentialBuilderFactory((AzureProperties)this.identityClientProperties);
        factory.setExecutorService((ExecutorService)threadPoolTaskExecutor.getThreadPoolExecutor());
        customizers.orderedStream().forEach(arg_0 -> ((ClientSecretCredentialBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    ClientCertificateCredentialBuilderFactory clientCertificateCredentialBuilderFactory(@Qualifier(value="springCloudAzureCredentialTaskExecutor") ThreadPoolTaskExecutor threadPoolTaskExecutor, ObjectProvider<AzureServiceClientBuilderCustomizer<ClientCertificateCredentialBuilder>> customizers) {
        ClientCertificateCredentialBuilderFactory factory = new ClientCertificateCredentialBuilderFactory((AzureProperties)this.identityClientProperties);
        factory.setExecutorService((ExecutorService)threadPoolTaskExecutor.getThreadPoolExecutor());
        customizers.orderedStream().forEach(arg_0 -> ((ClientCertificateCredentialBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    ManagedIdentityCredentialBuilderFactory managedIdentityCredentialBuilderFactory(ObjectProvider<AzureServiceClientBuilderCustomizer<ManagedIdentityCredentialBuilder>> customizers) {
        ManagedIdentityCredentialBuilderFactory factory = new ManagedIdentityCredentialBuilderFactory((AzureProperties)this.identityClientProperties);
        customizers.orderedStream().forEach(arg_0 -> ((ManagedIdentityCredentialBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    UsernamePasswordCredentialBuilderFactory usernamePasswordCredentialBuilderFactory(ObjectProvider<AzureServiceClientBuilderCustomizer<UsernamePasswordCredentialBuilder>> customizers) {
        UsernamePasswordCredentialBuilderFactory factory = new UsernamePasswordCredentialBuilderFactory((AzureProperties)this.identityClientProperties);
        customizers.orderedStream().forEach(arg_0 -> ((UsernamePasswordCredentialBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }

    @Bean
    static AzureServiceClientBuilderFactoryPostProcessor builderFactoryBeanPostProcessor() {
        return new AzureServiceClientBuilderFactoryPostProcessor();
    }

    @Bean(name={"springCloudAzureCredentialTaskExecutor"})
    @ConditionalOnMissingBean(name={"springCloudAzureCredentialTaskExecutor"})
    ThreadPoolTaskExecutor credentialTaskExecutor() {
        return new TaskExecutorBuilder().corePoolSize(8).allowCoreThreadTimeOut(true).threadNamePrefix("az-identity-").build();
    }

    static class IdentityClientProperties
    extends AbstractAzureHttpConfigurationProperties {
        IdentityClientProperties() {
        }
    }

    static class AzureServiceClientBuilderFactoryPostProcessor
    implements BeanPostProcessor,
    BeanFactoryAware {
        private BeanFactory beanFactory;

        AzureServiceClientBuilderFactoryPostProcessor() {
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof AbstractAzureCredentialBuilderFactory) {
                return bean;
            }
            if (bean instanceof AbstractAzureServiceClientBuilderFactory && this.beanFactory.containsBean("springCloudAzureDefaultCredential")) {
                AbstractAzureServiceClientBuilderFactory factory = (AbstractAzureServiceClientBuilderFactory)bean;
                factory.setDefaultTokenCredential((TokenCredential)this.beanFactory.getBean("springCloudAzureDefaultCredential"));
                factory.setTokenCredentialResolver((AzureCredentialResolver)this.beanFactory.getBean(AzureTokenCredentialResolver.class));
            }
            return bean;
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }
    }
}

