/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.storage.queue;

import com.azure.spring.cloud.autoconfigure.AzureServiceConfigurationBase;
import com.azure.spring.cloud.autoconfigure.condition.ConditionalOnAnyProperty;
import com.azure.spring.cloud.autoconfigure.context.AzureGlobalProperties;
import com.azure.spring.cloud.autoconfigure.implementation.storage.queue.properties.AzureStorageQueueProperties;
import com.azure.spring.cloud.core.customizer.AzureServiceClientBuilderCustomizer;
import com.azure.spring.cloud.core.implementation.util.AzureSpringIdentifier;
import com.azure.spring.cloud.core.provider.connectionstring.ServiceConnectionStringProvider;
import com.azure.spring.cloud.core.provider.connectionstring.StaticConnectionStringProvider;
import com.azure.spring.cloud.core.service.AzureServiceType;
import com.azure.spring.cloud.service.implementation.storage.queue.QueueServiceClientBuilderFactory;
import com.azure.spring.cloud.service.implementation.storage.queue.QueueServiceClientProperties;
import com.azure.storage.queue.QueueAsyncClient;
import com.azure.storage.queue.QueueClient;
import com.azure.storage.queue.QueueServiceAsyncClient;
import com.azure.storage.queue.QueueServiceClient;
import com.azure.storage.queue.QueueServiceClientBuilder;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnClass(value={QueueServiceClientBuilder.class})
@ConditionalOnProperty(value={"spring.cloud.azure.storage.queue.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnAnyProperty(prefix="spring.cloud.azure.storage.queue", name={"account-name", "endpoint", "connection-string"})
public class AzureStorageQueueAutoConfiguration
extends AzureServiceConfigurationBase {
    AzureStorageQueueAutoConfiguration(AzureGlobalProperties azureGlobalProperties) {
        super(azureGlobalProperties);
    }

    @Bean
    @ConfigurationProperties(value="spring.cloud.azure.storage.queue")
    AzureStorageQueueProperties azureStorageQueueProperties() {
        return this.loadProperties(this.getAzureGlobalProperties(), new AzureStorageQueueProperties());
    }

    @Bean
    @ConditionalOnMissingBean
    public QueueServiceClient queueServiceClient(QueueServiceClientBuilder builder) {
        return builder.buildClient();
    }

    @Bean
    @ConditionalOnMissingBean
    public QueueServiceAsyncClient queueServiceAsyncClient(QueueServiceClientBuilder builder) {
        return builder.buildAsyncClient();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.azure.storage.queue", name={"queue-name"})
    QueueClient queueClient(QueueServiceClient queueServiceClient, AzureStorageQueueProperties properties) {
        return queueServiceClient.getQueueClient(properties.getQueueName());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.cloud.azure.storage.queue", name={"queue-name"})
    QueueAsyncClient queueAsyncClient(QueueServiceAsyncClient queueServiceAsyncClient, AzureStorageQueueProperties properties) {
        return queueServiceAsyncClient.getQueueAsyncClient(properties.getQueueName());
    }

    @Bean
    @ConditionalOnMissingBean
    QueueServiceClientBuilderFactory queueServiceClientBuilderFactory(AzureStorageQueueProperties properties, ObjectProvider<ServiceConnectionStringProvider<AzureServiceType.StorageQueue>> connectionStringProviders, ObjectProvider<AzureServiceClientBuilderCustomizer<QueueServiceClientBuilder>> customizers) {
        QueueServiceClientBuilderFactory factory = new QueueServiceClientBuilderFactory((QueueServiceClientProperties)properties);
        factory.setSpringIdentifier(AzureSpringIdentifier.AZURE_SPRING_STORAGE_QUEUE);
        connectionStringProviders.orderedStream().findFirst().ifPresent(arg_0 -> ((QueueServiceClientBuilderFactory)factory).setConnectionStringProvider(arg_0));
        customizers.orderedStream().forEach(arg_0 -> ((QueueServiceClientBuilderFactory)factory).addBuilderCustomizer(arg_0));
        return factory;
    }

    @Bean
    @ConditionalOnMissingBean
    QueueServiceClientBuilder queueServiceClientBuilder(QueueServiceClientBuilderFactory factory) {
        return (QueueServiceClientBuilder)factory.build();
    }

    @Bean
    @ConditionalOnProperty(value={"spring.cloud.azure.storage.queue.connection-string"})
    StaticConnectionStringProvider<AzureServiceType.StorageQueue> staticStorageQueueConnectionStringProvider(AzureStorageQueueProperties storageQueueProperties) {
        return new StaticConnectionStringProvider((Object)AzureServiceType.STORAGE_QUEUE, storageQueueProperties.getConnectionString());
    }
}

