/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.trace.sleuth;

import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.spring.cloud.core.implementation.trace.AzureHttpClientBuilderFactoryBeanPostProcessor;
import com.azure.spring.cloud.trace.sleuth.SleuthHttpPolicy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;

@Role(value=2)
@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={SleuthHttpPolicy.class, Tracer.class})
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
public class AzureSleuthAutoConfiguration {
    public static final String DEFAULT_SLEUTH_HTTP_POLICY_BEAN_NAME = "AzureSleuthHttpPolicy";

    @Bean(name={"AzureSleuthHttpPolicy"})
    @ConditionalOnMissingBean(name={"AzureSleuthHttpPolicy"})
    public HttpPipelinePolicy azureSleuthHttpPolicy(Tracer tracer) {
        return new SleuthHttpPolicy(tracer);
    }

    @Role(value=2)
    @Bean
    @ConditionalOnMissingBean
    AzureHttpClientBuilderFactoryBeanPostProcessor httpClientBuilderFactoryBeanPostProcessor() {
        return new AzureHttpClientBuilderFactoryBeanPostProcessor(DEFAULT_SLEUTH_HTTP_POLICY_BEAN_NAME);
    }
}

