/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.aad.filter;

import com.azure.spring.cloud.autoconfigure.aad.properties.AadAuthenticationProperties;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jwt.JWTClaimsSet;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class UserPrincipal
implements Serializable {
    private static final long serialVersionUID = -3725690847771476854L;
    private static final String PERSONAL_ACCOUNT_TENANT_ID = "9188040d-6c67-4c5b-b112-36a304b66dad";
    private final String aadIssuedBearerToken;
    private final JWSObject jwsObject;
    private final JWTClaimsSet jwtClaimsSet;
    private Set<String> groups;
    private Set<String> roles;
    private String accessTokenForGraphApi;

    public UserPrincipal(String aadIssuedBearerToken, JWSObject jwsObject, JWTClaimsSet jwtClaimsSet) {
        this.aadIssuedBearerToken = aadIssuedBearerToken;
        this.jwsObject = jwsObject;
        this.jwtClaimsSet = jwtClaimsSet;
    }

    public String getAadIssuedBearerToken() {
        return this.aadIssuedBearerToken;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public String getAccessTokenForGraphApi() {
        return this.accessTokenForGraphApi;
    }

    public void setAccessTokenForGraphApi(String accessTokenForGraphApi) {
        this.accessTokenForGraphApi = accessTokenForGraphApi;
    }

    public boolean isMemberOf(AadAuthenticationProperties aadAuthenticationProperties, String group) {
        return aadAuthenticationProperties.isAllowedGroup(group) && Optional.of(this.groups).map(g -> g.contains(group)).orElse(false) != false;
    }

    public String getKeyId() {
        return this.jwsObject == null ? null : this.jwsObject.getHeader().getKeyID();
    }

    public String getIssuer() {
        return this.jwtClaimsSet == null ? null : this.jwtClaimsSet.getIssuer();
    }

    public String getSubject() {
        return this.jwtClaimsSet == null ? null : this.jwtClaimsSet.getSubject();
    }

    public Map<String, Object> getClaims() {
        return this.jwtClaimsSet == null ? null : this.jwtClaimsSet.getClaims();
    }

    public Object getClaim(String name) {
        return this.jwtClaimsSet == null ? null : this.jwtClaimsSet.getClaim(name);
    }

    public String getName() {
        return this.jwtClaimsSet == null ? null : (String)this.jwtClaimsSet.getClaim("name");
    }

    public String getTenantId() {
        return this.jwtClaimsSet == null ? null : (String)this.jwtClaimsSet.getClaim("tid");
    }

    public String getUserPrincipalName() {
        return this.jwtClaimsSet == null ? null : (String)this.jwtClaimsSet.getClaim("preferred_username");
    }

    public boolean isPersonalAccount() {
        return PERSONAL_ACCOUNT_TENANT_ID.equals(this.getTenantId());
    }
}

